"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-voronoi/src/Cell", ['module', 'exports', 'require', './Edge', './Diagram'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.cellHalfedgeEnd = cellHalfedgeEnd;
    exports.cellHalfedgeStart = cellHalfedgeStart;
    exports.clipCells = clipCells;
    exports.createCell = createCell;
    exports.sortCellHalfedges = sortCellHalfedges;

    var _Edge = require("./Edge");

    var _Diagram = require("./Diagram");

    function createCell(site) {
      return _Diagram.cells[site.index] = {
        site: site,
        halfedges: []
      };
    }

    function cellHalfedgeAngle(cell, edge) {
      var site = cell.site,
          va = edge.left,
          vb = edge.right;
      if (site === vb) vb = va, va = site;
      if (vb) return Math.atan2(vb[1] - va[1], vb[0] - va[0]);
      if (site === va) va = edge[1], vb = edge[0];else va = edge[0], vb = edge[1];
      return Math.atan2(va[0] - vb[0], vb[1] - va[1]);
    }

    function cellHalfedgeStart(cell, edge) {
      return edge[+(edge.left !== cell.site)];
    }

    function cellHalfedgeEnd(cell, edge) {
      return edge[+(edge.left === cell.site)];
    }

    function sortCellHalfedges() {
      for (var i = 0, n = _Diagram.cells.length, cell, halfedges, j, m; i < n; ++i) {
        if ((cell = _Diagram.cells[i]) && (m = (halfedges = cell.halfedges).length)) {
          var index = new Array(m),
              array = new Array(m);

          for (j = 0; j < m; ++j) index[j] = j, array[j] = cellHalfedgeAngle(cell, _Diagram.edges[halfedges[j]]);

          index.sort(function (i, j) {
            return array[j] - array[i];
          });

          for (j = 0; j < m; ++j) array[j] = halfedges[index[j]];

          for (j = 0; j < m; ++j) halfedges[j] = array[j];
        }
      }
    }

    function clipCells(x0, y0, x1, y1) {
      var nCells = _Diagram.cells.length,
          iCell,
          cell,
          site,
          iHalfedge,
          halfedges,
          nHalfedges,
          start,
          startX,
          startY,
          end,
          endX,
          endY,
          cover = true;

      for (iCell = 0; iCell < nCells; ++iCell) {
        if (cell = _Diagram.cells[iCell]) {
          site = cell.site;
          halfedges = cell.halfedges;
          iHalfedge = halfedges.length; // Remove any dangling clipped edges.

          while (iHalfedge--) {
            if (!_Diagram.edges[halfedges[iHalfedge]]) {
              halfedges.splice(iHalfedge, 1);
            }
          } // Insert any border edges as necessary.


          iHalfedge = 0, nHalfedges = halfedges.length;

          while (iHalfedge < nHalfedges) {
            end = cellHalfedgeEnd(cell, _Diagram.edges[halfedges[iHalfedge]]), endX = end[0], endY = end[1];
            start = cellHalfedgeStart(cell, _Diagram.edges[halfedges[++iHalfedge % nHalfedges]]), startX = start[0], startY = start[1];

            if (Math.abs(endX - startX) > _Diagram.epsilon || Math.abs(endY - startY) > _Diagram.epsilon) {
              halfedges.splice(iHalfedge, 0, _Diagram.edges.push((0, _Edge.createBorderEdge)(site, end, Math.abs(endX - x0) < _Diagram.epsilon && y1 - endY > _Diagram.epsilon ? [x0, Math.abs(startX - x0) < _Diagram.epsilon ? startY : y1] : Math.abs(endY - y1) < _Diagram.epsilon && x1 - endX > _Diagram.epsilon ? [Math.abs(startY - y1) < _Diagram.epsilon ? startX : x1, y1] : Math.abs(endX - x1) < _Diagram.epsilon && endY - y0 > _Diagram.epsilon ? [x1, Math.abs(startX - x1) < _Diagram.epsilon ? startY : y0] : Math.abs(endY - y0) < _Diagram.epsilon && endX - x0 > _Diagram.epsilon ? [Math.abs(startY - y0) < _Diagram.epsilon ? startX : x0, y0] : null)) - 1);
              ++nHalfedges;
            }
          }

          if (nHalfedges) cover = false;
        }
      } // If there weren’t any edges, have the closest site cover the extent.
      // It doesn’t matter which corner of the extent we measure!


      if (cover) {
        var dx,
            dy,
            d2,
            dc = Infinity;

        for (iCell = 0, cover = null; iCell < nCells; ++iCell) {
          if (cell = _Diagram.cells[iCell]) {
            site = cell.site;
            dx = site[0] - x0;
            dy = site[1] - y0;
            d2 = dx * dx + dy * dy;
            if (d2 < dc) dc = d2, cover = cell;
          }
        }

        if (cover) {
          var v00 = [x0, y0],
              v01 = [x0, y1],
              v11 = [x1, y1],
              v10 = [x1, y0];
          cover.halfedges.push(_Diagram.edges.push((0, _Edge.createBorderEdge)(site = cover.site, v00, v01)) - 1, _Diagram.edges.push((0, _Edge.createBorderEdge)(site, v01, v11)) - 1, _Diagram.edges.push((0, _Edge.createBorderEdge)(site, v11, v10)) - 1, _Diagram.edges.push((0, _Edge.createBorderEdge)(site, v10, v00)) - 1);
        }
      } // Lastly delete any cells with no edges; these were entirely clipped.


      for (iCell = 0; iCell < nCells; ++iCell) {
        if (cell = _Diagram.cells[iCell]) {
          if (!cell.halfedges.length) {
            delete _Diagram.cells[iCell];
          }
        }
      }
    }
  }
});
//# sourceMappingURL=Cell.js.map