"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-time/src/week", ['module', 'exports', 'require', './interval', './duration'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.wednesdays = exports.wednesday = exports.tuesdays = exports.tuesday = exports.thursdays = exports.thursday = exports.sundays = exports.sunday = exports.saturdays = exports.saturday = exports.mondays = exports.monday = exports.fridays = exports.friday = void 0;

    var _interval = _interopRequireDefault(require("./interval"));

    var _duration = require("./duration");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function weekday(i) {
      return (0, _interval.default)(function (date) {
        date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);
        date.setHours(0, 0, 0, 0);
      }, function (date, step) {
        date.setDate(date.getDate() + step * 7);
      }, function (start, end) {
        return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * _duration.durationMinute) / _duration.durationWeek;
      });
    }

    var sunday = weekday(0);
    exports.sunday = sunday;
    var monday = weekday(1);
    exports.monday = monday;
    var tuesday = weekday(2);
    exports.tuesday = tuesday;
    var wednesday = weekday(3);
    exports.wednesday = wednesday;
    var thursday = weekday(4);
    exports.thursday = thursday;
    var friday = weekday(5);
    exports.friday = friday;
    var saturday = weekday(6);
    exports.saturday = saturday;
    var sundays = sunday.range;
    exports.sundays = sundays;
    var mondays = monday.range;
    exports.mondays = mondays;
    var tuesdays = tuesday.range;
    exports.tuesdays = tuesdays;
    var wednesdays = wednesday.range;
    exports.wednesdays = wednesdays;
    var thursdays = thursday.range;
    exports.thursdays = thursdays;
    var fridays = friday.range;
    exports.fridays = fridays;
    var saturdays = saturday.range;
    exports.saturdays = saturdays;
  }
});
//# sourceMappingURL=week.js.map