"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-shape/src/curve/radial", ['module', 'exports', 'require', './linear'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.curveRadialLinear = void 0;
    exports.default = curveRadial;

    var _linear = _interopRequireDefault(require("./linear"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var curveRadialLinear = curveRadial(_linear.default);
    exports.curveRadialLinear = curveRadialLinear;

    function Radial(curve) {
      this._curve = curve;
    }

    Radial.prototype = {
      areaStart: function () {
        this._curve.areaStart();
      },
      areaEnd: function () {
        this._curve.areaEnd();
      },
      lineStart: function () {
        this._curve.lineStart();
      },
      lineEnd: function () {
        this._curve.lineEnd();
      },
      point: function (a, r) {
        this._curve.point(r * Math.sin(a), r * -Math.cos(a));
      }
    };

    function curveRadial(curve) {
      function radial(context) {
        return new Radial(curve(context));
      }

      radial._curve = curve;
      return radial;
    }
  }
});
//# sourceMappingURL=radial.js.map