"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-scale/src/radial", ['module', 'exports', 'require', './continuous', './init', './linear', './number'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = radial;

    var _continuous = _interopRequireDefault(require("./continuous"));

    var _init = require("./init");

    var _linear = require("./linear");

    var _number = _interopRequireDefault(require("./number"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function square(x) {
      return Math.sign(x) * x * x;
    }

    function unsquare(x) {
      return Math.sign(x) * Math.sqrt(Math.abs(x));
    }

    function radial() {
      var squared = (0, _continuous.default)(),
          range = [0, 1],
          round = false,
          unknown;

      function scale(x) {
        var y = unsquare(squared(x));
        return isNaN(y) ? unknown : round ? Math.round(y) : y;
      }

      scale.invert = function (y) {
        return squared.invert(square(y));
      };

      scale.domain = function (_) {
        return arguments.length ? (squared.domain(_), scale) : squared.domain();
      };

      scale.range = function (_) {
        return arguments.length ? (squared.range((range = Array.from(_, _number.default)).map(square)), scale) : range.slice();
      };

      scale.rangeRound = function (_) {
        return scale.range(_).round(true);
      };

      scale.round = function (_) {
        return arguments.length ? (round = !!_, scale) : round;
      };

      scale.clamp = function (_) {
        return arguments.length ? (squared.clamp(_), scale) : squared.clamp();
      };

      scale.unknown = function (_) {
        return arguments.length ? (unknown = _, scale) : unknown;
      };

      scale.copy = function () {
        return radial(squared.domain(), range).round(round).clamp(squared.clamp()).unknown(unknown);
      };

      _init.initRange.apply(scale, arguments);

      return (0, _linear.linearish)(scale);
    }
  }
});
//# sourceMappingURL=radial.js.map