"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-scale/src/quantize", ['module', 'exports', 'require', '../../../lib-vendor/d3-array/src/index', './linear', './init'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = quantize;

    var _index = require("../../../lib-vendor/d3-array/src/index");

    var _linear = require("./linear");

    var _init = require("./init");

    function quantize() {
      var x0 = 0,
          x1 = 1,
          n = 1,
          domain = [0.5],
          range = [0, 1],
          unknown;

      function scale(x) {
        return x != null && x <= x ? range[(0, _index.bisect)(domain, x, 0, n)] : unknown;
      }

      function rescale() {
        var i = -1;
        domain = new Array(n);

        while (++i < n) domain[i] = ((i + 1) * x1 - (i - n) * x0) / (n + 1);

        return scale;
      }

      scale.domain = function (_) {
        return arguments.length ? ([x0, x1] = _, x0 = +x0, x1 = +x1, rescale()) : [x0, x1];
      };

      scale.range = function (_) {
        return arguments.length ? (n = (range = Array.from(_)).length - 1, rescale()) : range.slice();
      };

      scale.invertExtent = function (y) {
        var i = range.indexOf(y);
        return i < 0 ? [NaN, NaN] : i < 1 ? [x0, domain[0]] : i >= n ? [domain[n - 1], x1] : [domain[i - 1], domain[i]];
      };

      scale.unknown = function (_) {
        return arguments.length ? (unknown = _, scale) : scale;
      };

      scale.thresholds = function () {
        return domain.slice();
      };

      scale.copy = function () {
        return quantize().domain([x0, x1]).range(range).unknown(unknown);
      };

      return _init.initRange.apply((0, _linear.linearish)(scale), arguments);
    }
  }
});
//# sourceMappingURL=quantize.js.map