"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-scale/src/pow", ['module', 'exports', 'require', './linear', './continuous', './init'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = pow;
    exports.powish = powish;
    exports.sqrt = sqrt;

    var _linear = require("./linear");

    var _continuous = require("./continuous");

    var _init = require("./init");

    function transformPow(exponent) {
      return function (x) {
        return x < 0 ? -Math.pow(-x, exponent) : Math.pow(x, exponent);
      };
    }

    function transformSqrt(x) {
      return x < 0 ? -Math.sqrt(-x) : Math.sqrt(x);
    }

    function transformSquare(x) {
      return x < 0 ? -x * x : x * x;
    }

    function powish(transform) {
      var scale = transform(_continuous.identity, _continuous.identity),
          exponent = 1;

      function rescale() {
        return exponent === 1 ? transform(_continuous.identity, _continuous.identity) : exponent === 0.5 ? transform(transformSqrt, transformSquare) : transform(transformPow(exponent), transformPow(1 / exponent));
      }

      scale.exponent = function (_) {
        return arguments.length ? (exponent = +_, rescale()) : exponent;
      };

      return (0, _linear.linearish)(scale);
    }

    function pow() {
      var scale = powish((0, _continuous.transformer)());

      scale.copy = function () {
        return (0, _continuous.copy)(scale, pow()).exponent(scale.exponent());
      };

      _init.initRange.apply(scale, arguments);

      return scale;
    }

    function sqrt() {
      return pow.apply(null, arguments).exponent(0.5);
    }
  }
});
//# sourceMappingURL=pow.js.map