"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-interpolate/src/rgb", ['module', 'exports', 'require', '../../../lib-vendor/d3-color/src/index', './basis', './basisClosed', './color'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.rgbBasisClosed = exports.rgbBasis = exports.default = void 0;

    var _index = require("../../../lib-vendor/d3-color/src/index");

    var _basis = _interopRequireDefault(require("./basis"));

    var _basisClosed = _interopRequireDefault(require("./basisClosed"));

    var _color = _interopRequireWildcard(require("./color"));

    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function") return null;var cacheBabelInterop = new WeakMap();var cacheNodeInterop = new WeakMap();return (_getRequireWildcardCache = function (nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }

    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache(nodeInterop);if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var _default = function rgbGamma(y) {
      var color = (0, _color.gamma)(y);

      function rgb(start, end) {
        var r = color((start = (0, _index.rgb)(start)).r, (end = (0, _index.rgb)(end)).r),
            g = color(start.g, end.g),
            b = color(start.b, end.b),
            opacity = (0, _color.default)(start.opacity, end.opacity);
        return function (t) {
          start.r = r(t);
          start.g = g(t);
          start.b = b(t);
          start.opacity = opacity(t);
          return start + "";
        };
      }

      rgb.gamma = rgbGamma;
      return rgb;
    }(1);

    exports.default = _default;

    function rgbSpline(spline) {
      return function (colors) {
        var n = colors.length,
            r = new Array(n),
            g = new Array(n),
            b = new Array(n),
            i,
            color;

        for (i = 0; i < n; ++i) {
          color = (0, _index.rgb)(colors[i]);
          r[i] = color.r || 0;
          g[i] = color.g || 0;
          b[i] = color.b || 0;
        }

        r = spline(r);
        g = spline(g);
        b = spline(b);
        color.opacity = 1;
        return function (t) {
          color.r = r(t);
          color.g = g(t);
          color.b = b(t);
          return color + "";
        };
      };
    }

    var rgbBasis = rgbSpline(_basis.default);
    exports.rgbBasis = rgbBasis;
    var rgbBasisClosed = rgbSpline(_basisClosed.default);
    exports.rgbBasisClosed = rgbBasisClosed;
  }
});
//# sourceMappingURL=rgb.js.map