"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-array/src/greatestIndex", ['module', 'exports', 'require', './ascending', './maxIndex'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = greatestIndex;

    var _ascending = _interopRequireDefault(require("./ascending"));

    var _maxIndex = _interopRequireDefault(require("./maxIndex"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function greatestIndex(values, compare = _ascending.default) {
      if (compare.length === 1) return (0, _maxIndex.default)(values, compare);
      let maxValue;
      let max = -1;
      let index = -1;

      for (const value of values) {
        ++index;

        if (max < 0 ? compare(value, value) === 0 : compare(value, maxValue) > 0) {
          maxValue = value;
          max = index;
        }
      }

      return max;
    }
  }
});
//# sourceMappingURL=greatestIndex.js.map