Liferay.Loader.define("analytics-reports-web$d3-array@3.2.4/src/nice", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { tickIncrement } from "./ticks.js";

    export default function nice(start, stop, count) {
      let prestep;
      while (true) {
        const step = tickIncrement(start, stop, count);
        if (step === prestep || step === 0 || !isFinite(step)) {
          return [start, stop];
        } else if (step > 0) {
          start = Math.floor(start / step) * step;
          stop = Math.ceil(stop / step) * step;
        } else if (step < 0) {
          start = Math.ceil(start * step) / step;
          stop = Math.floor(stop * step) / step;
        }
        prestep = step;
      }
    }
  }
});
//# sourceMappingURL=nice.js.map