"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-time/src/utcYear", ['module', 'exports', 'require', './interval'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.utcYears = exports.default = void 0;

    var _interval = _interopRequireDefault(require("./interval"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var utcYear = (0, _interval.default)(function (date) {
      date.setUTCMonth(0, 1);
      date.setUTCHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setUTCFullYear(date.getUTCFullYear() + step);
    }, function (start, end) {
      return end.getUTCFullYear() - start.getUTCFullYear();
    }, function (date) {
      return date.getUTCFullYear();
    }); // An optimized implementation for this simple case.

    utcYear.every = function (k) {
      return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : (0, _interval.default)(function (date) {
        date.setUTCFullYear(Math.floor(date.getUTCFullYear() / k) * k);
        date.setUTCMonth(0, 1);
        date.setUTCHours(0, 0, 0, 0);
      }, function (date, step) {
        date.setUTCFullYear(date.getUTCFullYear() + step * k);
      });
    };

    var _default = utcYear;
    exports.default = _default;
    var utcYears = utcYear.range;
    exports.utcYears = utcYears;
  }
});
//# sourceMappingURL=utcYear.js.map