"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-time/src/ticks", ['module', 'exports', 'require', '../../../lib-vendor/d3-array/src/index', './duration', './millisecond', './second', './minute', './hour', './day', './week', './month', './year', './utcMinute', './utcHour', './utcDay', './utcWeek', './utcMonth', './utcYear'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.utcTicks = exports.utcTickInterval = exports.timeTicks = exports.timeTickInterval = void 0;

    var _index = require("../../../lib-vendor/d3-array/src/index");

    var _duration = require("./duration");

    var _millisecond = _interopRequireDefault(require("./millisecond"));

    var _second = _interopRequireDefault(require("./second"));

    var _minute = _interopRequireDefault(require("./minute"));

    var _hour = _interopRequireDefault(require("./hour"));

    var _day = _interopRequireDefault(require("./day"));

    var _week = require("./week");

    var _month = _interopRequireDefault(require("./month"));

    var _year = _interopRequireDefault(require("./year"));

    var _utcMinute = _interopRequireDefault(require("./utcMinute"));

    var _utcHour = _interopRequireDefault(require("./utcHour"));

    var _utcDay = _interopRequireDefault(require("./utcDay"));

    var _utcWeek = require("./utcWeek");

    var _utcMonth = _interopRequireDefault(require("./utcMonth"));

    var _utcYear = _interopRequireDefault(require("./utcYear"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ticker(year, month, week, day, hour, minute) {
      const tickIntervals = [[_second.default, 1, _duration.durationSecond], [_second.default, 5, 5 * _duration.durationSecond], [_second.default, 15, 15 * _duration.durationSecond], [_second.default, 30, 30 * _duration.durationSecond], [minute, 1, _duration.durationMinute], [minute, 5, 5 * _duration.durationMinute], [minute, 15, 15 * _duration.durationMinute], [minute, 30, 30 * _duration.durationMinute], [hour, 1, _duration.durationHour], [hour, 3, 3 * _duration.durationHour], [hour, 6, 6 * _duration.durationHour], [hour, 12, 12 * _duration.durationHour], [day, 1, _duration.durationDay], [day, 2, 2 * _duration.durationDay], [week, 1, _duration.durationWeek], [month, 1, _duration.durationMonth], [month, 3, 3 * _duration.durationMonth], [year, 1, _duration.durationYear]];

      function ticks(start, stop, count) {
        const reverse = stop < start;
        if (reverse) [start, stop] = [stop, start];
        const interval = count && typeof count.range === "function" ? count : tickInterval(start, stop, count);
        const ticks = interval ? interval.range(start, +stop + 1) : []; // inclusive stop

        return reverse ? ticks.reverse() : ticks;
      }

      function tickInterval(start, stop, count) {
        const target = Math.abs(stop - start) / count;
        const i = (0, _index.bisector)(([,, step]) => step).right(tickIntervals, target);
        if (i === tickIntervals.length) return year.every((0, _index.tickStep)(start / _duration.durationYear, stop / _duration.durationYear, count));
        if (i === 0) return _millisecond.default.every(Math.max((0, _index.tickStep)(start, stop, count), 1));
        const [t, step] = tickIntervals[target / tickIntervals[i - 1][2] < tickIntervals[i][2] / target ? i - 1 : i];
        return t.every(step);
      }

      return [ticks, tickInterval];
    }

    const [utcTicks, utcTickInterval] = ticker(_utcYear.default, _utcMonth.default, _utcWeek.utcSunday, _utcDay.default, _utcHour.default, _utcMinute.default);
    exports.utcTickInterval = utcTickInterval;
    exports.utcTicks = utcTicks;
    const [timeTicks, timeTickInterval] = ticker(_year.default, _month.default, _week.sunday, _day.default, _hour.default, _minute.default);
    exports.timeTickInterval = timeTickInterval;
    exports.timeTicks = timeTicks;
  }
});
//# sourceMappingURL=ticks.js.map