"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-shape/src/stack", ['module', 'exports', 'require', './array', './constant', './offset/none', './order/none'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _array = _interopRequireDefault(require("./array"));

    var _constant = _interopRequireDefault(require("./constant"));

    var _none = _interopRequireDefault(require("./offset/none"));

    var _none2 = _interopRequireDefault(require("./order/none"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function stackValue(d, key) {
      return d[key];
    }

    function stackSeries(key) {
      const series = [];
      series.key = key;
      return series;
    }

    function _default() {
      var keys = (0, _constant.default)([]),
          order = _none2.default,
          offset = _none.default,
          value = stackValue;

      function stack(data) {
        var sz = Array.from(keys.apply(this, arguments), stackSeries),
            i,
            n = sz.length,
            j = -1,
            oz;

        for (const d of data) {
          for (i = 0, ++j; i < n; ++i) {
            (sz[i][j] = [0, +value(d, sz[i].key, j, data)]).data = d;
          }
        }

        for (i = 0, oz = (0, _array.default)(order(sz)); i < n; ++i) {
          sz[oz[i]].index = i;
        }

        offset(sz, oz);
        return sz;
      }

      stack.keys = function (_) {
        return arguments.length ? (keys = typeof _ === "function" ? _ : (0, _constant.default)(Array.from(_)), stack) : keys;
      };

      stack.value = function (_) {
        return arguments.length ? (value = typeof _ === "function" ? _ : (0, _constant.default)(+_), stack) : value;
      };

      stack.order = function (_) {
        return arguments.length ? (order = _ == null ? _none2.default : typeof _ === "function" ? _ : (0, _constant.default)(Array.from(_)), stack) : order;
      };

      stack.offset = function (_) {
        return arguments.length ? (offset = _ == null ? _none.default : _, stack) : offset;
      };

      return stack;
    }
  }
});
//# sourceMappingURL=stack.js.map