"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-array/src/least", ['module', 'exports', 'require', './ascending'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = least;

    var _ascending = _interopRequireDefault(require("./ascending"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function least(values, compare = _ascending.default) {
      let min;
      let defined = false;

      if (compare.length === 1) {
        let minValue;

        for (const element of values) {
          const value = compare(element);

          if (defined ? (0, _ascending.default)(value, minValue) < 0 : (0, _ascending.default)(value, value) === 0) {
            min = element;
            minValue = value;
            defined = true;
          }
        }
      } else {
        for (const value of values) {
          if (defined ? compare(value, min) < 0 : compare(value, value) === 0) {
            min = value;
            defined = true;
          }
        }
      }

      return min;
    }
  }
});
//# sourceMappingURL=least.js.map