"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-array/src/greatest", ['module', 'exports', 'require', './ascending'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = greatest;

    var _ascending = _interopRequireDefault(require("./ascending"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function greatest(values, compare = _ascending.default) {
      let max;
      let defined = false;

      if (compare.length === 1) {
        let maxValue;

        for (const element of values) {
          const value = compare(element);

          if (defined ? (0, _ascending.default)(value, maxValue) > 0 : (0, _ascending.default)(value, value) === 0) {
            max = element;
            maxValue = value;
            defined = true;
          }
        }
      } else {
        for (const value of values) {
          if (defined ? compare(value, max) > 0 : compare(value, value) === 0) {
            max = value;
            defined = true;
          }
        }
      }

      return max;
    }
  }
});
//# sourceMappingURL=greatest.js.map