"use strict";

Liferay.Loader.define("analytics-reports-web$victory-vendor@36.7.0/lib-vendor/d3-array/src/cross", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = cross;

    function length(array) {
      return array.length | 0;
    }

    function empty(length) {
      return !(length > 0);
    }

    function arrayify(values) {
      return typeof values !== "object" || "length" in values ? values : Array.from(values);
    }

    function reducer(reduce) {
      return values => reduce(...values);
    }

    function cross(...values) {
      const reduce = typeof values[values.length - 1] === "function" && reducer(values.pop());
      values = values.map(arrayify);
      const lengths = values.map(length);
      const j = values.length - 1;
      const index = new Array(j + 1).fill(0);
      const product = [];
      if (j < 0 || lengths.some(empty)) return product;

      while (true) {
        product.push(index.map((j, i) => values[i][j]));
        let i = j;

        while (++index[i] === lengths[i]) {
          if (i === 0) return reduce ? product.map(reduce) : product;
          index[i--] = 0;
        }
      }
    }
  }
});
//# sourceMappingURL=cross.js.map