Liferay.Loader.define("analytics-reports-web$d3-shape@3.2.0/src/symbol/star", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { sin, cos, sqrt, pi, tau } from "../math.js";

    const ka = 0.89081309152928522810;
    const kr = sin(pi / 10) / sin(7 * pi / 10);
    const kx = sin(tau / 10) * kr;
    const ky = -cos(tau / 10) * kr;

    export default {
      draw(context, size) {
        const r = sqrt(size * ka);
        const x = kx * r;
        const y = ky * r;
        context.moveTo(0, -r);
        context.lineTo(x, y);
        for (let i = 1; i < 5; ++i) {
          const a = tau * i / 5;
          const c = cos(a);
          const s = sin(a);
          context.lineTo(s * r, -c * r);
          context.lineTo(c * x - s * y, s * x + c * y);
        }
        context.closePath();
      }
    };
  }
});
//# sourceMappingURL=star.js.map