Liferay.Loader.define("analytics-reports-web$d3-shape@3.2.0/src/stack", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import array from "./array.js";
    import constant from "./constant.js";
    import offsetNone from "./offset/none.js";
    import orderNone from "./order/none.js";

    function stackValue(d, key) {
      return d[key];
    }

    function stackSeries(key) {
      const series = [];
      series.key = key;
      return series;
    }

    export default function () {
      var keys = constant([]),
          order = orderNone,
          offset = offsetNone,
          value = stackValue;

      function stack(data) {
        var sz = Array.from(keys.apply(this, arguments), stackSeries),
            i,
            n = sz.length,
            j = -1,
            oz;

        for (const d of data) {
          for (i = 0, ++j; i < n; ++i) {
            (sz[i][j] = [0, +value(d, sz[i].key, j, data)]).data = d;
          }
        }

        for (i = 0, oz = array(order(sz)); i < n; ++i) {
          sz[oz[i]].index = i;
        }

        offset(sz, oz);
        return sz;
      }

      stack.keys = function (_) {
        return arguments.length ? (keys = typeof _ === "function" ? _ : constant(Array.from(_)), stack) : keys;
      };

      stack.value = function (_) {
        return arguments.length ? (value = typeof _ === "function" ? _ : constant(+_), stack) : value;
      };

      stack.order = function (_) {
        return arguments.length ? (order = _ == null ? orderNone : typeof _ === "function" ? _ : constant(Array.from(_)), stack) : order;
      };

      stack.offset = function (_) {
        return arguments.length ? (offset = _ == null ? offsetNone : _, stack) : offset;
      };

      return stack;
    }
  }
});
//# sourceMappingURL=stack.js.map