Liferay.Loader.define("analytics-reports-web$d3-shape@3.2.0/src/curve/basisOpen", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { point } from "./basis.js";

    function BasisOpen(context) {
      this._context = context;
    }

    BasisOpen.prototype = {
      areaStart: function () {
        this._line = 0;
      },
      areaEnd: function () {
        this._line = NaN;
      },
      lineStart: function () {
        this._x0 = this._x1 = this._y0 = this._y1 = NaN;
        this._point = 0;
      },
      lineEnd: function () {
        if (this._line || this._line !== 0 && this._point === 3) this._context.closePath();
        this._line = 1 - this._line;
      },
      point: function (x, y) {
        x = +x, y = +y;
        switch (this._point) {
          case 0:
            this._point = 1;break;
          case 1:
            this._point = 2;break;
          case 2:
            this._point = 3;var x0 = (this._x0 + 4 * this._x1 + x) / 6,
                y0 = (this._y0 + 4 * this._y1 + y) / 6;this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0);break;
          case 3:
            this._point = 4; // falls through
          default:
            point(this, x, y);break;
        }
        this._x0 = this._x1, this._x1 = x;
        this._y0 = this._y1, this._y1 = y;
      }
    };

    export default function (context) {
      return new BasisOpen(context);
    }
  }
});
//# sourceMappingURL=basisOpen.js.map