Liferay.Loader.define("analytics-reports-web$d3-ease@3.0.1/src/elastic", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { tpmt } from "./math.js";

    var tau = 2 * Math.PI,
        amplitude = 1,
        period = 0.3;

    export var elasticIn = function custom(a, p) {
      var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

      function elasticIn(t) {
        return a * tpmt(- --t) * Math.sin((s - t) / p);
      }

      elasticIn.amplitude = function (a) {
        return custom(a, p * tau);
      };
      elasticIn.period = function (p) {
        return custom(a, p);
      };

      return elasticIn;
    }(amplitude, period);

    export var elasticOut = function custom(a, p) {
      var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

      function elasticOut(t) {
        return 1 - a * tpmt(t = +t) * Math.sin((t + s) / p);
      }

      elasticOut.amplitude = function (a) {
        return custom(a, p * tau);
      };
      elasticOut.period = function (p) {
        return custom(a, p);
      };

      return elasticOut;
    }(amplitude, period);

    export var elasticInOut = function custom(a, p) {
      var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

      function elasticInOut(t) {
        return ((t = t * 2 - 1) < 0 ? a * tpmt(-t) * Math.sin((s - t) / p) : 2 - a * tpmt(t) * Math.sin((s + t) / p)) / 2;
      }

      elasticInOut.amplitude = function (a) {
        return custom(a, p * tau);
      };
      elasticInOut.period = function (p) {
        return custom(a, p);
      };

      return elasticInOut;
    }(amplitude, period);
  }
});
//# sourceMappingURL=elastic.js.map