Liferay.Loader.define("analytics-reports-web$d3-scale@2.2.2/src/pow", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import { linearish } from "./linear";
  import { copy, identity, transformer } from "./continuous";
  import { initRange } from "./init";

  function transformPow(exponent) {
    return function (x) {
      return x < 0 ? -Math.pow(-x, exponent) : Math.pow(x, exponent);
    };
  }

  function transformSqrt(x) {
    return x < 0 ? -Math.sqrt(-x) : Math.sqrt(x);
  }

  function transformSquare(x) {
    return x < 0 ? -x * x : x * x;
  }

  export function powish(transform) {
    var scale = transform(identity, identity),
        exponent = 1;

    function rescale() {
      return exponent === 1 ? transform(identity, identity) : exponent === 0.5 ? transform(transformSqrt, transformSquare) : transform(transformPow(exponent), transformPow(1 / exponent));
    }

    scale.exponent = function (_) {
      return arguments.length ? (exponent = +_, rescale()) : exponent;
    };

    return linearish(scale);
  }

  export default function pow() {
    var scale = powish(transformer());

    scale.copy = function () {
      return copy(scale, pow()).exponent(scale.exponent());
    };

    initRange.apply(scale, arguments);

    return scale;
  }

  export function sqrt() {
    return pow.apply(null, arguments).exponent(0.5);
  }
});
//# sourceMappingURL=pow.js.map