Liferay.Loader.define("analytics-reports-web@1.0.7/js/components/BasicInformation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/sticker', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

  var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

  var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

  var _classnames2 = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function Author(_ref) {
    var authorName = _ref.authorName,
        authorPortraitURL = _ref.authorPortraitURL,
        authorUserId = _ref.authorUserId;
    var stickerColor = parseInt(authorUserId, 10) % 10;
    return _react["default"].createElement("div", {
      className: "text-secondary"
    }, _react["default"].createElement(_sticker["default"], {
      className: (0, _classnames2["default"])('c-mr-2 sticker-user-icon', _defineProperty({}, "user-icon-color-".concat(stickerColor), !authorPortraitURL)),
      shape: "circle",
      size: "sm"
    }, authorPortraitURL ? _react["default"].createElement("img", {
      alt: "".concat(authorName, "."),
      className: "sticker-img",
      src: authorPortraitURL
    }) : _react["default"].createElement(_icon["default"], {
      symbol: "user"
    })), Liferay.Util.sub(Liferay.Language.get('authored-by-x'), authorName));
  }

  function BasicInformation(_ref2) {
    var authorName = _ref2.authorName,
        authorPortraitURL = _ref2.authorPortraitURL,
        authorUserId = _ref2.authorUserId,
        languageTag = _ref2.languageTag,
        publishDate = _ref2.publishDate,
        title = _ref2.title;
    var formattedPublishDate = Intl.DateTimeFormat(languageTag, {
      day: 'numeric',
      month: 'long',
      year: 'numeric'
    }).format(publishDate);
    return _react["default"].createElement("div", {
      className: "sidebar-section"
    }, _react["default"].createElement(_layout["default"].ContentRow, null, _react["default"].createElement(_layout["default"].ContentCol, {
      expand: true
    }, _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement("span", {
      className: "component-title text-truncate-inline",
      "data-tooltip-align": "top",
      title: title
    }, _react["default"].createElement("span", {
      className: "text-truncate"
    }, title))))), _react["default"].createElement(_layout["default"].ContentRow, null, _react["default"].createElement(_layout["default"].ContentCol, {
      expand: true
    }, _react["default"].createElement("p", {
      className: "text-secondary"
    }, Liferay.Util.sub(Liferay.Language.get('published-on-x'), formattedPublishDate)))), _react["default"].createElement(_layout["default"].ContentRow, null, _react["default"].createElement(_layout["default"].ContentCol, {
      expand: true
    }, _react["default"].createElement(Author, {
      authorName: authorName,
      authorPortraitURL: authorPortraitURL,
      authorUserId: authorUserId
    }))));
  }

  var _default = BasicInformation;
  exports["default"] = _default;
  //# sourceMappingURL=BasicInformation.js.map
});
//# sourceMappingURL=BasicInformation.js.map