Liferay.Loader.define("analytics-reports-web@1.0.65/js/components/CustomDots", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = CustomDot;
    exports.ActiveDot = ActiveDot;
    exports.Dot = Dot;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    function CustomDot(props) {
      return props.active ? /*#__PURE__*/_react.default.createElement(ActiveDot, props) : /*#__PURE__*/_react.default.createElement(Dot, props);
    }
    /**
     * Component to customize the content of recharts Line#ActiveDot
     * http://recharts.org/en-US/api/Line#activeDot
     */

    function ActiveDot(props) {
      var cx = props.cx,
          cy = props.cy,
          fill = props.fill,
          r = props.r,
          shape = props.shape,
          _props$strokeWidth = props.strokeWidth,
          strokeWidth = _props$strokeWidth === void 0 ? 0 : _props$strokeWidth;

      if (cy === null) {
        return null;
      } else if (shape === 'square') {
        var squareSize = r * 2;
        return (/*#__PURE__*/_react.default.createElement("rect", {
            fill: fill,
            height: squareSize,
            strokeWidth: strokeWidth,
            width: squareSize,
            x: cx - r,
            y: cy - r
          })
        );
      } else {
        return (/*#__PURE__*/_react.default.createElement("circle", {
            cx: cx,
            cy: cy,
            fill: fill,
            r: r,
            strokeWidth: strokeWidth
          })
        );
      }
    }

    ActiveDot.proptypes = {
      cx: _propTypes.default.number.required,
      cy: _propTypes.default.number.required,
      fill: _propTypes.default.string.required,
      r: _propTypes.default.number.required,
      shape: _propTypes.default.oneOf(['square', 'circle']),
      strokeWidth: _propTypes.default.number.required
    };
    /**
     * Component to customize the content of recharts Line#dot
     * http://recharts.org/en-US/api/Line#dot
     */

    function Dot(props) {
      var cx = props.cx,
          cy = props.cy,
          fill = props.fill,
          r = props.r,
          shape = props.shape;

      if (cy === null) {
        return null;
      } else if (shape === 'square') {
        var squareSize = r * 2;
        return (/*#__PURE__*/_react.default.createElement("rect", {
            fill: fill,
            height: squareSize,
            width: squareSize,
            x: cx - r,
            y: cy - r
          })
        );
      } else {
        return (/*#__PURE__*/_react.default.createElement("circle", {
            cx: cx,
            cy: cy,
            fill: fill,
            r: r
          })
        );
      }
    }

    Dot.proptypes = {
      cx: _propTypes.default.number.required,
      cy: _propTypes.default.number.required,
      fill: _propTypes.default.string.required,
      r: _propTypes.default.number.required,
      shape: _propTypes.default.oneOf(['circle', 'square'])
    };
    //# sourceMappingURL=CustomDots.js.map
  }
});
//# sourceMappingURL=CustomDots.js.map