"use strict";

Liferay.Loader.define("analytics-reports-web$dnd-core@11.1.3/dist/cjs/utils/js_utils", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.get = get;
    exports.without = without;
    exports.isString = isString;
    exports.isObject = isObject;
    exports.xor = xor;
    exports.intersection = intersection;

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    // cheap lodash replacements

    /**
     * drop-in replacement for _.get
     * @param obj
     * @param path
     * @param defaultValue
     */
    function get(obj, path, defaultValue) {
      return path.split('.').reduce(function (a, c) {
        return a && a[c] ? a[c] : defaultValue || null;
      }, obj);
    }
    /**
     * drop-in replacement for _.without
     */

    function without(items, item) {
      return items.filter(function (i) {
        return i !== item;
      });
    }
    /**
     * drop-in replacement for _.isString
     * @param input
     */

    function isString(input) {
      return typeof input === 'string';
    }
    /**
     * drop-in replacement for _.isString
     * @param input
     */

    function isObject(input) {
      return _typeof(input) === 'object';
    }
    /**
     * repalcement for _.xor
     * @param itemsA
     * @param itemsB
     */

    function xor(itemsA, itemsB) {
      var map = new Map();

      var insertItem = function insertItem(item) {
        map.set(item, map.has(item) ? map.get(item) + 1 : 1);
      };

      itemsA.forEach(insertItem);
      itemsB.forEach(insertItem);
      var result = [];
      map.forEach(function (count, key) {
        if (count === 1) {
          result.push(key);
        }
      });
      return result;
    }
    /**
     * replacement for _.intersection
     * @param itemsA
     * @param itemsB
     */

    function intersection(itemsA, itemsB) {
      return itemsA.filter(function (t) {
        return itemsB.indexOf(t) > -1;
      });
    }
  }
});
//# sourceMappingURL=js_utils.js.map