'use strict';
// https://tc39.github.io/String.prototype.matchAll/

Liferay.Loader.define('analytics-reports-web$core-js@2.6.11/library/modules/es7.string.match-all', ['module', 'exports', 'require', './_export', './_defined', './_to-length', './_is-regexp', './_flags', './_iter-create'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var $export = require('./_export');
    var defined = require('./_defined');
    var toLength = require('./_to-length');
    var isRegExp = require('./_is-regexp');
    var getFlags = require('./_flags');
    var RegExpProto = RegExp.prototype;

    var $RegExpStringIterator = function (regexp, string) {
      this._r = regexp;
      this._s = string;
    };

    require('./_iter-create')($RegExpStringIterator, 'RegExp String', function next() {
      var match = this._r.exec(this._s);
      return { value: match, done: match === null };
    });

    $export($export.P, 'String', {
      matchAll: function matchAll(regexp) {
        defined(this);
        if (!isRegExp(regexp)) throw TypeError(regexp + ' is not a regexp!');
        var S = String(this);
        var flags = 'flags' in RegExpProto ? String(regexp.flags) : getFlags.call(regexp);
        var rx = new RegExp(regexp.source, ~flags.indexOf('g') ? flags : 'g' + flags);
        rx.lastIndex = toLength(regexp.lastIndex);
        return new $RegExpStringIterator(rx, S);
      }
    });
  }
});
//# sourceMappingURL=es7.string.match-all.js.map