Liferay.Loader.define("analytics-reports-web@1.0.63/js/AnalyticsReportsApp", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$react', './components/Navigation', './context/ChartStateContext', './context/ConnectionContext', './context/StoreContext', '../css/analytics-reports-app.scss'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Navigation = _interopRequireDefault(require("./components/Navigation"));

    var _ChartStateContext = require("./context/ChartStateContext");

    var _ConnectionContext = _interopRequireDefault(require("./context/ConnectionContext"));

    var _StoreContext = require("./context/StoreContext");

    require("../css/analytics-reports-app.scss");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var initialState = {
      data: null,
      error: null,
      loading: false
    };

    var dataReducer = function dataReducer(state, action) {
      var _action$data, _action$data2;

      switch (action.type) {
        case 'LOAD_DATA':
          return _objectSpread(_objectSpread({}, state), {}, {
            loading: true
          });

        case 'SET_ERROR':
          return _objectSpread(_objectSpread({}, state), {}, {
            error: action.error,
            loading: false
          });

        case 'SET_DATA':
          return {
            data: _objectSpread(_objectSpread({}, action.data), {}, {
              publishedToday: new Date().toDateString() === new Date((_action$data = action.data) === null || _action$data === void 0 ? void 0 : _action$data.publishDate).toDateString()
            }),
            error: (_action$data2 = action.data) === null || _action$data2 === void 0 ? void 0 : _action$data2.error,
            loading: false
          };

        default:
          return initialState;
      }
    };

    function _default(_ref) {
      var context = _ref.context;
      var analyticsReportsDataURL = context.analyticsReportsDataURL;
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      var _useReducer = (0, _react.useReducer)(dataReducer, initialState),
          _useReducer2 = _slicedToArray(_useReducer, 2),
          state = _useReducer2[0],
          dispatch = _useReducer2[1];

      var safeDispatch = function safeDispatch(action) {
        if (isMounted()) {
          dispatch(action);
        }
      };

      var getData = function getData(fetchURL, timeSpanKey, timeSpanOffset) {
        safeDispatch({
          type: 'LOAD_DATA'
        });
        var body = !timeSpanOffset && !!timeSpanKey ? {
          timeSpanKey: timeSpanKey,
          timeSpanOffset: timeSpanOffset
        } : {};
        (0, _frontendJsWeb.fetch)(fetchURL, {
          body: body,
          method: 'POST'
        }).then(function (response) {
          return response.json().then(function (data) {
            return safeDispatch({
              data: data.context,
              type: 'SET_DATA'
            });
          });
        }).catch(function () {
          safeDispatch({
            error: Liferay.Language.get('an-unexpected-error-occurred'),
            type: 'SET_ERROR'
          });
        });
      };

      (0, _react.useEffect)(function () {
        getData(analyticsReportsDataURL); // eslint-disable-next-line react-hooks/exhaustive-deps
      }, [analyticsReportsDataURL]);
      var handleSelectedLanguageClick = (0, _react.useCallback)(function (url, timeSpanKey, timeSpanOffset) {
        getData(url, timeSpanKey, timeSpanOffset);
      }, // eslint-disable-next-line react-hooks/exhaustive-deps
      []);
      return state.loading ? /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, {
        small: true
      }) : state.error ? /*#__PURE__*/_react.default.createElement(_alert.default, {
        displayType: "danger",
        variant: "stripe"
      }, state.error) : state.data && /*#__PURE__*/_react.default.createElement(_ConnectionContext.default.Provider, {
        value: {
          validAnalyticsConnection: state.data.validAnalyticsConnection
        }
      }, /*#__PURE__*/_react.default.createElement(_StoreContext.StoreContextProvider, {
        value: {
          publishedToday: state.data.publishedToday
        }
      }, /*#__PURE__*/_react.default.createElement(_ChartStateContext.ChartStateContextProvider, {
        publishDate: state.data.publishDate,
        timeRange: state.data.timeRange,
        timeSpanKey: state.data.timeSpanKey
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "analytics-reports-app"
      }, /*#__PURE__*/_react.default.createElement(_Navigation.default, {
        author: state.data.author,
        canonicalURL: state.data.canonicalURL,
        endpoints: state.data.endpoints,
        languageTag: state.data.languageTag,
        namespace: state.data.namespace,
        onSelectedLanguageClick: handleSelectedLanguageClick,
        page: state.data.page,
        pagePublishDate: state.data.publishDate,
        pageTitle: state.data.title,
        timeSpanOptions: state.data.timeSpans,
        viewURLs: state.data.viewURLs
      })))));
    }
    //# sourceMappingURL=AnalyticsReportsApp.js.map
  }
});
//# sourceMappingURL=AnalyticsReportsApp.js.map