Liferay.Loader.define('analytics-reports-web@1.0.49/js/utils/dateFormat', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.generateDateFormatters = void 0;

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */

    /**
     * It generates a set of functions used to produce
     * internationalized date related content.
     */
    const generateDateFormatters = key => {
      /**
       * Given a date-like string produces the day of the month
       *
       * For 'en-US'
       * String => '16'
       */

      /**
       * Given 2 date objects it produces a user friendly date interval
       *
       * For 'en-US'
       * [Date, Date] => '16 - Jun 21, 2020'
       */
      return {
        formatChartTitle: function formatChartTitle([initialDate, finalDate]) {

          const dateFormatter = (date, options = {
            day: 'numeric',
            month: 'short',
            year: 'numeric'
          }) => Intl.DateTimeFormat([key], options).format(date);

          const equalMonth = initialDate.getMonth() === finalDate.getMonth();
          const equalYear = initialDate.getYear() === finalDate.getYear();
          const initialDateOptions = {
            day: 'numeric',
            month: equalMonth && equalYear ? undefined : 'short',
            year: equalYear ? undefined : 'numeric'
          };

          if (finalDate - initialDate <= 1000 * 60 * 60 * 24) {
            return dateFormatter(finalDate);
          }

          return "".concat(dateFormatter(initialDate, initialDateOptions), " - ").concat(dateFormatter(finalDate));
        }
        /**
         * Given a date-like string it produces a internationalized long date
         *
         * For 'en-US'
         * String => '06/17/2020'
         */

        ,
        formatLongDate: function formatLongDate(value) {
          return Intl.DateTimeFormat([key]).format(new Date(value));
        },
        formatNumericDay: function formatNumericDay(value) {
          return Intl.DateTimeFormat([key], {
            day: 'numeric'
          }).format(new Date(value));
        }
        /**
         * Given a date-like string produces the hour of the day
         *
         * For 'en-US'
         * String => '04 AM'
         */

        ,
        formatNumericHour: function formatNumericHour(value) {
          return Intl.DateTimeFormat([key], {
            hour: 'numeric'
          }).format(new Date(value));
        }
      };
    };

    exports.generateDateFormatters = generateDateFormatters;
    //# sourceMappingURL=dateFormat.js.map
  }
});
//# sourceMappingURL=dateFormat.js.map