Liferay.Loader.define("analytics-reports-web@1.0.49/js/utils/APIService", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports._getFormDataRequest = _getFormDataRequest;
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function APIService({
      endpoints: {
        analyticsReportsHistoricalReadsURL,
        analyticsReportsHistoricalViewsURL,
        analyticsReportsTotalReadsURL,
        analyticsReportsTotalViewsURL,
        analyticsReportsTrafficSourcesURL
      },
      namespace,
      page: {
        plid
      }
    }) {

      return {
        getHistoricalReads: function getHistoricalReads({
          timeSpanKey,
          timeSpanOffset
        }) {
          return _fetchWithError(analyticsReportsHistoricalReadsURL, {
            body: _getFormDataRequest({
              plid,
              timeSpanKey,
              timeSpanOffset
            }, namespace),
            method: 'POST'
          });
        },
        getHistoricalViews: function getHistoricalViews({
          timeSpanKey,
          timeSpanOffset
        }) {
          return _fetchWithError(analyticsReportsHistoricalViewsURL, {
            body: _getFormDataRequest({
              plid,
              timeSpanKey,
              timeSpanOffset
            }, namespace),
            method: 'POST'
          });
        },
        getTotalReads: function getTotalReads() {
          return _fetchWithError(analyticsReportsTotalReadsURL, {
            body: _getFormDataRequest({
              plid
            }, namespace),
            method: 'POST'
          });
        },
        getTotalViews: function getTotalViews() {
          return _fetchWithError(analyticsReportsTotalViewsURL, {
            body: _getFormDataRequest({
              plid
            }, namespace),
            method: 'POST'
          });
        },
        getTrafficSources: function getTrafficSources() {
          return _fetchWithError(analyticsReportsTrafficSourcesURL, {
            body: _getFormDataRequest({
              plid
            }, namespace),
            method: 'POST'
          });
        }
      };
    }

    var _default = APIService;
    /**
     *
     *
     * @export
     * @param {Object} body
     * @param {string} prefix
     * @param {FormData} [formData=new FormData()]
     * @returns {FormData}
     */

    exports.default = _default;

    function _getFormDataRequest(body, prefix, formData = new FormData()) {
      Object.entries(body).forEach(([key, value]) => {
        formData.append("".concat(prefix).concat(key), value);
      });
      return formData;
    }
    /**
     * Wrapper to `fetch` function throwing an error when `error` is present in the response
     */

    function _fetchWithError(url, options = {}) {
      return (0, _frontendJsWeb.fetch)(url, options).then(response => response.json()).then(objectResponse => {
        if (objectResponse.error) {
          throw objectResponse.error;
        }

        return objectResponse;
      });
    }
    //# sourceMappingURL=APIService.js.map
  }
});
//# sourceMappingURL=APIService.js.map