Liferay.Loader.define("analytics-reports-web@1.0.49/js/context/StoreContext", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.StoreContextProvider = StoreContextProvider;
    exports.useHistoricalWarning = useHistoricalWarning;
    exports.useWarning = useWarning;
    exports.StoreContext = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const INITIAL_STATE = {
      historicalWarning: false,
      publishedToday: false,
      warning: false
    };
    const ADD_HISTORICAL_WARNING = 'add-historical-warning';
    const ADD_WARNING = 'add-warning';

    const noop = () => {};

    const StoreContext = /*#__PURE__*/(0, _react.createContext)([INITIAL_STATE, noop]);
    exports.StoreContext = StoreContext;

    function reducer(state = INITIAL_STATE, action) {
      if (action.type === ADD_HISTORICAL_WARNING) {
        return state.historicalWarning ? state : _objectSpread(_objectSpread({}, state), {}, {
          historicalWarning: true
        });
      } else if (action.type === ADD_WARNING) {
        return state.warning ? state : _objectSpread(_objectSpread({}, state), {}, {
          warning: true
        });
      }

      return state;
    }

    function StoreContextProvider({
      children,
      value
    }) {
      const stateAndDispatch = (0, _react.useReducer)(reducer, _objectSpread(_objectSpread({}, INITIAL_STATE), value));
      return (/*#__PURE__*/_react.default.createElement(StoreContext.Provider, {
          value: stateAndDispatch
        }, children)
      );
    }

    function useHistoricalWarning() {
      const [state, dispatch] = (0, _react.useContext)(StoreContext);
      const addHistoricalWarning = (0, _react.useCallback)(() => {
        dispatch({
          type: ADD_HISTORICAL_WARNING
        });
      }, [dispatch]);
      const hasHistoricalWarning = state.historicalWarning;
      return [hasHistoricalWarning, addHistoricalWarning];
    }

    function useWarning() {
      const [state, dispatch] = (0, _react.useContext)(StoreContext);
      const addWarning = (0, _react.useCallback)(() => {
        dispatch({
          type: ADD_WARNING
        });
      }, [dispatch]);
      const hasWarning = state.warning;
      return [hasWarning, addWarning];
    }
    //# sourceMappingURL=StoreContext.js.map
  }
});
//# sourceMappingURL=StoreContext.js.map