Liferay.Loader.define("analytics-reports-web@1.0.49/js/context/ChartStateContext", ['module', 'exports', 'require', 'frontend-js-react-web$react', './ConnectionContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useDateTitle = useDateTitle;
    exports.useIsPreviousPeriodButtonDisabled = useIsPreviousPeriodButtonDisabled;
    exports.usePreviousTimeSpan = exports.useSetLoading = exports.useNextTimeSpan = exports.useChartState = exports.useChangeTimeSpanKey = exports.useAddDataSetItems = exports.ChartStateContextProvider = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ConnectionContext = _interopRequireDefault(require("./ConnectionContext"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const ADD_DATA_SET_ITEMS = 'add-data-keys';
    const CHANGE_TIME_SPAN_KEY = 'change-time-span-key';
    const NEXT_TIME_SPAN = 'next-time-span';
    const PREV_TIME_SPAN = 'previous-time-span';
    const SET_LOADING = 'set-loading';
    const INITIAL_STATE = {
      dataSet: {
        histogram: [],
        keyList: [],
        totals: []
      },
      loading: true,
      publishDate: null,
      timeRange: null,
      timeSpanKey: null,
      timeSpanOffset: 0
    };
    const FALLBACK_DATA_SET_ITEM = {
      histogram: [],
      value: null
    };
    const ChartStateContext = /*#__PURE__*/(0, _react.createContext)(INITIAL_STATE);

    const ChartStateContextProvider = ({
      children,
      publishDate,
      timeRange,
      timeSpanKey
    }) => {
      const stateAndDispatch = (0, _react.useReducer)(reducer, _objectSpread(_objectSpread({}, INITIAL_STATE), {}, {
        publishDate,
        timeRange,
        timeSpanKey
      }));
      return (/*#__PURE__*/_react.default.createElement(ChartStateContext.Provider, {
          value: stateAndDispatch
        }, children)
      );
    };

    exports.ChartStateContextProvider = ChartStateContextProvider;

    const useAddDataSetItems = () => {
      const [, dispatch] = (0, _react.useContext)(ChartStateContext);
      const {
        validAnalyticsConnection
      } = (0, _react.useContext)(_ConnectionContext.default);
      return (0, _react.useCallback)(payload => dispatch({
        payload,
        type: ADD_DATA_SET_ITEMS,
        validAnalyticsConnection
      }), [dispatch, validAnalyticsConnection]);
    };

    exports.useAddDataSetItems = useAddDataSetItems;

    const useChangeTimeSpanKey = () => {
      const [, dispatch] = (0, _react.useContext)(ChartStateContext);
      return payload => dispatch({
        payload,
        type: CHANGE_TIME_SPAN_KEY
      });
    };

    exports.useChangeTimeSpanKey = useChangeTimeSpanKey;

    const useChartState = () => {
      const [state] = (0, _react.useContext)(ChartStateContext);
      return state;
    };

    exports.useChartState = useChartState;

    function useDateTitle() {
      const [state] = (0, _react.useContext)(ChartStateContext);
      const {
        histogram
      } = state.dataSet;
      const {
        timeRange
      } = state;

      if (histogram.length) {
        const firstDateLabel = histogram[0].label;
        const lastDateLabel = histogram[histogram.length - 1].label;
        return {
          firstDate: new Date(firstDateLabel),
          lastDate: new Date(lastDateLabel)
        };
      } else {
        return {
          firstDate: new Date(timeRange.startDate),
          lastDate: new Date(timeRange.endDate)
        };
      }
    }

    function useIsPreviousPeriodButtonDisabled() {
      const [state] = (0, _react.useContext)(ChartStateContext);
      const {
        histogram
      } = state.dataSet;
      const {
        publishDate
      } = state;

      if (histogram.length) {
        const firstDateLabel = histogram[0].label;
        const firstDate = new Date(firstDateLabel);
        const publishedDate = new Date(publishDate);
        return firstDate < publishedDate;
      }

      return true;
    }

    const useNextTimeSpan = () => {
      const [, dispatch] = (0, _react.useContext)(ChartStateContext);
      return () => dispatch({
        type: NEXT_TIME_SPAN
      });
    };

    exports.useNextTimeSpan = useNextTimeSpan;

    const useSetLoading = () => {
      const [, dispatch] = (0, _react.useContext)(ChartStateContext);
      return (0, _react.useCallback)(() => dispatch({
        type: SET_LOADING
      }), [dispatch]);
    };

    exports.useSetLoading = useSetLoading;

    const usePreviousTimeSpan = () => {
      const [, dispatch] = (0, _react.useContext)(ChartStateContext);
      return () => dispatch({
        type: PREV_TIME_SPAN
      });
    };
    /**
     * {
    		"loading": false,
    		"timeSpanOffset": 1,
    		"timeSpanKey": "last-7-days",
    		"dataSet": {
    			"keyList": [
    				"analyticsReportsHistoricalReads",
    				"analyticsReportsHistoricalViews"
    			],
    			"totals": {
    				"analyticsReportsHistoricalReads": 225000,
    				"analyticsReportsHistoricalViews": 144245
    			},
    			"histogram": [
    				{
    					"analyticsReportsHistoricalViews": 5412,
    					"label": "2020-02-02T00:00",
    					"analyticsReportsHistoricalReads": 5000
    				},
    				...
    			]
    		}
    	}
     *
     */

    exports.usePreviousTimeSpan = usePreviousTimeSpan;

    function reducer(state, action) {
      let nextState;

      switch (action.type) {
        case ADD_DATA_SET_ITEMS:
          nextState = action.payload.keys.reduce((state, key) => {
            var _action$payload$dataS, _action$payload$dataS2;

            const dataSetItem = (_action$payload$dataS = (_action$payload$dataS2 = action.payload.dataSetItems) === null || _action$payload$dataS2 === void 0 ? void 0 : _action$payload$dataS2[key]) !== null && _action$payload$dataS !== void 0 ? _action$payload$dataS : FALLBACK_DATA_SET_ITEM;
            return addDataSetItem(state, _objectSpread(_objectSpread({}, action.payload), {}, {
              dataSetItem,
              key
            }), action.validAnalyticsConnection);
          }, state);
          break;

        case CHANGE_TIME_SPAN_KEY:
          nextState = _objectSpread(_objectSpread({}, state), {}, {
            timeSpanKey: action.payload.key,
            timeSpanOffset: 0
          });
          break;

        case NEXT_TIME_SPAN:
          nextState = _objectSpread(_objectSpread({}, state), {}, {
            timeSpanOffset: state.timeSpanOffset - 1
          });
          break;

        case PREV_TIME_SPAN:
          nextState = _objectSpread(_objectSpread({}, state), {}, {
            timeSpanOffset: state.timeSpanOffset + 1
          });
          break;

        case SET_LOADING:
          nextState = setLoadingState(state);
          break;

        default:
          state = nextState;
          break;
      }

      return nextState;
    }
    /**
     * Declares the state as loading and resets the dataSet histogram values
     */

    function setLoadingState(state) {
      /**
       * The dataSet does not need to be reset
       */
      if (!state.dataSet) {
        return _objectSpread(_objectSpread({}, state), {}, {
          loading: true
        });
      }

      const histogram = state.dataSet.histogram.map(set => {
        const newSet = {};
        const setArray = Object.entries(set);

        for (const index in setArray) {
          const [key, value] = setArray[index];

          if (key === 'label') {
            newSet[key] = value;
          } else {
            newSet[key] = null;
          }
        }

        return newSet;
      });
      const arrayTotals = Object.entries(state.dataSet.totals);
      const totals = {};

      for (const index in arrayTotals) {
        const [key] = arrayTotals[index];
        totals[key] = null;
      }

      const nextState = _objectSpread(_objectSpread({}, state), {}, {
        dataSet: _objectSpread(_objectSpread({}, state.dataSet), {}, {
          histogram,
          totals
        }),
        loading: true
      });

      return nextState;
    }

    function mergeDataSets({
      key,
      newData,
      previousDataSet = {
        histogram: [],
        keyList: [],
        totals: []
      },
      publishDate,
      timeSpanComparator,
      validAnalyticsConnection
    }) {
      const resultDataSet = {
        keyList: [...previousDataSet.keyList, key],
        totals: _objectSpread(_objectSpread({}, previousDataSet.totals), {}, {
          [key]: newData.value
        })
      };
      const publishDateObject = new Date(publishDate);
      const newFormattedHistogram = newData.histogram.map(h => {
        const valueDataObject = new Date(h.key);

        if (valueDataObject < publishDateObject && publishDateObject - valueDataObject > timeSpanComparator || !validAnalyticsConnection) {
          return {
            [key]: null,
            label: h.key
          };
        }

        return {
          [key]: h.value,
          label: h.key
        };
      });

      if (newFormattedHistogram.length === 0) {
        return _objectSpread(_objectSpread({}, resultDataSet), {}, {
          histogram: previousDataSet.histogram
        });
      }

      let start = 0;
      const mergeHistogram = [];

      while (start < newData.histogram.length) {
        if (!previousDataSet.histogram[start]) {
          mergeHistogram.push(_objectSpread({}, newFormattedHistogram[start]));
        } else if (newFormattedHistogram[start].label === previousDataSet.histogram[start].label) {
          mergeHistogram.push(_objectSpread(_objectSpread({}, newFormattedHistogram[start]), previousDataSet.histogram[start]));
        }

        start = start + 1;
      }

      resultDataSet.histogram = mergeHistogram;
      return resultDataSet;
    }
    /**
     * Adds dataSetItem to the dataSet
     *
     * payload = {
     * 	dataSet: {
     * 		histogram: Array<{
     *			key: string, // '2020-01-24T00:00'
     *			value: number
     * 		}>
     * 		values: number
     * 	},
     * 	key: string,
     *  timeSpanComparator: number,
     * }
     */

    function addDataSetItem(state, payload, validAnalyticsConnection) {
      /**
       * The dataSetItem is recognized as substitutive when the
       * previous state was in loading state.
       */
      const previousDataSet = state.loading === true ? undefined : state.dataSet;
      return _objectSpread(_objectSpread({}, state), {}, {
        dataSet: mergeDataSets({
          key: payload.key,
          newData: payload.dataSetItem,
          previousDataSet,
          publishDate: state.publishDate,
          timeSpanComparator: payload.timeSpanComparator,
          validAnalyticsConnection
        }),
        loading: false
      });
    }
    //# sourceMappingURL=ChartStateContext.js.map
  }
});
//# sourceMappingURL=ChartStateContext.js.map