Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/detail/SocialDetail", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/list', 'frontend-js-react-web$classnames', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../context/ChartStateContext', '../../utils/dateFormat', '../../utils/numberFormat', '../TimeSpanSelector', '../TotalCount'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = SocialDetail;

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _metalPosition = require("frontend-js-metal-web$metal-position");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ChartStateContext = require("../../context/ChartStateContext");

    var _dateFormat = require("../../utils/dateFormat");

    var _numberFormat = require("../../utils/numberFormat");

    var _TimeSpanSelector = _interopRequireDefault(require("../TimeSpanSelector"));

    var _TotalCount = _interopRequireDefault(require("../TotalCount"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    const SOCIAL_MEDIA_COLORS = {
      facebook: '#4B9BFF',
      instagram: '#FFB46E',
      linkedin: '#7785FF',
      others: '#6B6C7E',
      pinterest: '#50D2A0',
      snapchat: '#FFD76E',
      tiktok: '#FF73C3',
      twitter: '#5FC8FF',
      youtube: '#FF5F5F'
    };

    function SocialDetail({
      currentPage,
      languageTag,
      showTimeSpanSelector = false,
      timeSpanOptions,
      trafficShareDataProvider,
      trafficVolumeDataProvider
    }) {
      const {
        referringSocialMedia
      } = currentPage.data;
      const dateFormatters = (0, _react.useMemo)(() => (0, _dateFormat.generateDateFormatters)(languageTag), [languageTag]);
      const {
        firstDate,
        lastDate
      } = (0, _ChartStateContext.useDateTitle)();
      const title = dateFormatters.formatChartTitle([firstDate, lastDate]);
      const chartState = (0, _ChartStateContext.useChartState)();
      const isPreviousPeriodButtonDisabled = (0, _ChartStateContext.useIsPreviousPeriodButtonDisabled)();
      const changeTimeSpanKey = (0, _ChartStateContext.useChangeTimeSpanKey)();
      const previousTimeSpan = (0, _ChartStateContext.usePreviousTimeSpan)();
      const nextTimeSpan = (0, _ChartStateContext.useNextTimeSpan)();

      const keyToHexColor = name => {
        var _SOCIAL_MEDIA_COLORS$;

        return (_SOCIAL_MEDIA_COLORS$ = SOCIAL_MEDIA_COLORS[name]) !== null && _SOCIAL_MEDIA_COLORS$ !== void 0 ? _SOCIAL_MEDIA_COLORS$ : '#666666';
      };

      const keyToWidth = index => {
        if (index === 0) {
          return '100%';
        }

        return "".concat(referringSocialMedia[index].trafficAmount * 100 / referringSocialMedia[0].trafficAmount, "%");
      };

      const [highlighted, setHighlighted] = (0, _react.useState)(null);

      function handleLegendMouseEnter(name) {
        setHighlighted(name);
      }

      function handleLegendMouseLeave() {
        setHighlighted(null);
      }

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "c-p-3 traffic-source-detail"
        }, showTimeSpanSelector && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-3 c-mt-2"
        }, /*#__PURE__*/_react.default.createElement(_TimeSpanSelector.default, {
          disabledNextTimeSpan: chartState.timeSpanOffset === 0,
          disabledPreviousPeriodButton: isPreviousPeriodButtonDisabled,
          onNextTimeSpanClick: nextTimeSpan,
          onPreviousTimeSpanClick: previousTimeSpan,
          onTimeSpanChange: event => {
            const {
              value
            } = event.target;
            changeTimeSpanKey({
              key: value
            });
          },
          timeSpanKey: chartState.timeSpanKey,
          timeSpanOptions: timeSpanOptions
        })), title && /*#__PURE__*/_react.default.createElement("h5", {
          className: "c-mb-4"
        }, title)), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "c-mb-2",
          dataProvider: trafficVolumeDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('traffic-volume')),
          languageTag: languageTag,
          popoverAlign: _metalPosition.Align.Bottom,
          popoverHeader: Liferay.Language.get('traffic-volume'),
          popoverMessage: Liferay.Language.get('traffic-volume-is-the-number-of-page-views-coming-from-one-channel'),
          popoverPosition: "bottom"
        }), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "c-mb-3",
          dataProvider: trafficShareDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('traffic-share')),
          percentage: true,
          popoverHeader: Liferay.Language.get('traffic-share'),
          popoverMessage: Liferay.Language.get('traffic-share-is-the-percentage-of-traffic-sent-to-your-page-by-one-channel')
        }), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "list-group-pages-list"
        }, /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, {
          className: "text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, Liferay.Language.get('top-referring-social-media')))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, null, /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('traffic'))))), referringSocialMedia.map(({
          name,
          title,
          trafficAmount
        }, index) => {
          const listItemClasses = (0, _classnames.default)({
            dim: highlighted && name !== highlighted
          });
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              className: listItemClasses,
              flex: true,
              key: title,
              onMouseOut: handleLegendMouseLeave,
              onMouseOver: () => handleLegendMouseEnter(name)
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              style: {
                width: '70px'
              }
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement("span", {
              className: "c-mr-2 text-secondary"
            }, title))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              className: "align-self-center",
              expand: true
            }, /*#__PURE__*/_react.default.createElement("div", {
              style: {
                backgroundColor: keyToHexColor(name),
                height: '16px',
                width: keyToWidth(index)
              }
            })), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              className: "align-self-center"
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "align-self-end c-ml-2 font-weight-semi-bold text-dark"
            }, (0, _numberFormat.numberFormat)(languageTag, trafficAmount))))
          );
        })))
      );
    }
    //# sourceMappingURL=SocialDetail.js.map
  }
});
//# sourceMappingURL=SocialDetail.js.map