Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/detail/ReferralDetail", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../context/ChartStateContext', '../../utils/dateFormat', '../../utils/numberFormat', '../Hint', '../TimeSpanSelector', '../TotalCount'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = ReferralDetail;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _metalPosition = require("frontend-js-metal-web$metal-position");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ChartStateContext = require("../../context/ChartStateContext");

    var _dateFormat = require("../../utils/dateFormat");

    var _numberFormat = require("../../utils/numberFormat");

    var _Hint = _interopRequireDefault(require("../Hint"));

    var _TimeSpanSelector = _interopRequireDefault(require("../TimeSpanSelector"));

    var _TotalCount = _interopRequireDefault(require("../TotalCount"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    const ITEMS_TO_SHOW = 5;

    function ReferralDetail({
      currentPage,
      languageTag,
      showTimeSpanSelector = false,
      timeSpanOptions,
      trafficShareDataProvider,
      trafficVolumeDataProvider
    }) {
      const [isReferringPagesExpanded, setIsReferringPagesExpanded] = (0, _react.useState)(false);
      const [isReferringDomainsExpanded, setIsReferringDomainsExpanded] = (0, _react.useState)(false);
      const {
        referringDomains,
        referringPages
      } = currentPage.data;
      const dateFormatters = (0, _react.useMemo)(() => (0, _dateFormat.generateDateFormatters)(languageTag), [languageTag]);
      const {
        firstDate,
        lastDate
      } = (0, _ChartStateContext.useDateTitle)();
      const title = (0, _react.useMemo)(() => {
        return dateFormatters.formatChartTitle([firstDate, lastDate]);
      }, [dateFormatters, firstDate, lastDate]);
      const chartState = (0, _ChartStateContext.useChartState)();
      const isPreviousPeriodButtonDisabled = (0, _ChartStateContext.useIsPreviousPeriodButtonDisabled)();
      const changeTimeSpanKey = (0, _ChartStateContext.useChangeTimeSpanKey)();
      const nextTimeSpan = (0, _ChartStateContext.useNextTimeSpan)();
      const previousTimeSpan = (0, _ChartStateContext.usePreviousTimeSpan)();

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "c-p-3 traffic-source-detail"
        }, showTimeSpanSelector && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-3 c-mt-2"
        }, /*#__PURE__*/_react.default.createElement(_TimeSpanSelector.default, {
          disabledNextTimeSpan: chartState.timeSpanOffset === 0,
          disabledPreviousPeriodButton: isPreviousPeriodButtonDisabled,
          onNextTimeSpanClick: nextTimeSpan,
          onPreviousTimeSpanClick: previousTimeSpan,
          onTimeSpanChange: event => {
            const {
              value
            } = event.target;
            changeTimeSpanKey({
              key: value
            });
          },
          timeSpanKey: chartState.timeSpanKey,
          timeSpanOptions: timeSpanOptions
        })), title && /*#__PURE__*/_react.default.createElement("h5", {
          className: "c-mb-4"
        }, title)), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "c-mb-2",
          dataProvider: trafficVolumeDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('traffic-volume')),
          languageTag: languageTag,
          popoverAlign: _metalPosition.Align.Bottom,
          popoverHeader: Liferay.Language.get('traffic-volume'),
          popoverMessage: Liferay.Language.get('traffic-volume-is-the-number-of-page-views-coming-from-one-channel'),
          popoverPosition: "bottom"
        }), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "c-mb-3",
          dataProvider: trafficShareDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('traffic-share')),
          percentage: true,
          popoverHeader: Liferay.Language.get('traffic-share'),
          popoverMessage: Liferay.Language.get('traffic-share-is-the-percentage-of-traffic-sent-to-your-page-by-one-channel')
        }), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "list-group-pages-list"
        }, /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, {
          className: "text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, Liferay.Language.get('top-referring-pages'), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          message: Liferay.Language.get('top-referring-pages-help'),
          title: Liferay.Language.get('top-referring-pages')
        }))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, null, /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('traffic'))))), referringPages.slice(0, isReferringPagesExpanded ? 10 : ITEMS_TO_SHOW).map(({
          trafficAmount,
          url
        }) => {
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true,
              key: url
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
              className: "text-truncate-inline",
              "data-tooltip-align": "top",
              title: url
            }, /*#__PURE__*/_react.default.createElement("a", {
              className: "c-mr-2 text-primary text-truncate text-truncate-reverse",
              href: url,
              target: "_blank"
            }, url))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "align-self-end font-weight-semi-bold text-dark"
            }, (0, _numberFormat.numberFormat)(languageTag, trafficAmount))))
          );
        })), referringPages.length > 5 && /*#__PURE__*/_react.default.createElement(_button.default, {
          borderless: true,
          className: "c-mb-4",
          displayType: "secondary",
          onClick: () => setIsReferringPagesExpanded(!isReferringPagesExpanded),
          small: true
        }, isReferringPagesExpanded ? /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-less')) : /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-more'))), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "list-group-pages-list"
        }, /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, {
          className: "text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, Liferay.Language.get('top-referring-domains'), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          message: Liferay.Language.get('top-referring-domains-help'),
          title: Liferay.Language.get('top-referring-domains')
        }))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, null, /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('traffic'))))), referringDomains.slice(0, isReferringDomainsExpanded ? 10 : ITEMS_TO_SHOW).map(({
          trafficAmount,
          url
        }) => {
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true,
              key: url
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
              className: "text-truncate-inline",
              "data-tooltip-align": "top",
              title: url
            }, /*#__PURE__*/_react.default.createElement("a", {
              className: "c-mr-2 text-primary text-truncate",
              href: url,
              target: "_blank"
            }, url))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "align-self-end font-weight-semi-bold text-dark"
            }, (0, _numberFormat.numberFormat)(languageTag, trafficAmount))))
          );
        })), referringDomains.length > 5 && /*#__PURE__*/_react.default.createElement(_button.default, {
          borderless: true,
          className: "c-mb-4",
          displayType: "secondary",
          onClick: () => setIsReferringDomainsExpanded(!isReferringDomainsExpanded),
          small: true
        }, isReferringDomainsExpanded ? /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-less')) : /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-more'))))
      );
    }
    //# sourceMappingURL=ReferralDetail.js.map
  }
});
//# sourceMappingURL=ReferralDetail.js.map