Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/Translation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ChartStateContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Translation;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ChartStateContext = require("../context/ChartStateContext");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function Translation({
      defaultLanguage,
      onSelectedLanguageClick,
      viewURLs
    }) {
      const [active, setActive] = (0, _react.useState)(false);
      const selectedLanguage = (0, _react.useMemo)(() => {
        var _viewURLs$find;

        return ((_viewURLs$find = viewURLs.find(language => language.selected)) === null || _viewURLs$find === void 0 ? void 0 : _viewURLs$find.languageId) || defaultLanguage;
      }, [defaultLanguage, viewURLs]);
      const chartState = (0, _ChartStateContext.useChartState)();
      return (/*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement("h5", null, Liferay.Language.get('languages-translated-into')), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, Liferay.Language.get('select-language-to-view-its-metrics'))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, /*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          hasLeftSymbols: true,
          onActiveChange: setActive,
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            className: "btn-monospaced",
            displayType: "secondary",
            small: true
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: selectedLanguage.toLowerCase()
          }), /*#__PURE__*/_react.default.createElement("span", {
            className: "d-block font-weight-normal",
            style: {
              fontSize: '9px'
            }
          }, selectedLanguage))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, Object.values(viewURLs).map((language, index) => /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          active: language.selected && language.languageId,
          key: index,
          onClick: () => {
            onSelectedLanguageClick(language.viewURL, chartState.timeSpanKey, chartState.timeSpanOffset);
          },
          symbolLeft: language.languageId.toLowerCase()
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement("span", null, language.languageId)), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, /*#__PURE__*/_react.default.createElement(_label.default, {
          displayType: language.default ? 'primary' : 'success'
        }, language.default ? Liferay.Language.get('default') : Liferay.Language.get('translated'))))))))))
      );
    }
    //# sourceMappingURL=Translation.js.map
  }
});
//# sourceMappingURL=Translation.js.map