Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/TrafficSources", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../context/ConnectionContext', '../context/StoreContext', '../utils/numberFormat', './EmptyPieChart', './Hint'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = TrafficSources;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _recharts = require("frontend-js-recharts$recharts");

    var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

    var _StoreContext = require("../context/StoreContext");

    var _numberFormat = require("../utils/numberFormat");

    var _EmptyPieChart = _interopRequireDefault(require("./EmptyPieChart"));

    var _Hint = _interopRequireDefault(require("./Hint"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    const COLORS_MAP = {
      direct: '#FF73C3',
      organic: '#4B9FFF',
      paid: '#FFB46E',
      referral: '#FF5F5F',
      social: '#50D2A0'
    };
    const PIE_CHART_SIZES = {
      height: 80,
      innerRadius: 25,
      paddingAngle: 1,
      radius: 40,
      width: 100
    };
    /**
     * Used when the traffic source name is not within the COLORS_MAP
     */

    const FALLBACK_COLOR = '#e92563';

    const getColorByName = name => COLORS_MAP[name] || FALLBACK_COLOR;

    function TrafficSources({
      dataProvider,
      languageTag,
      onTrafficSourceClick
    }) {
      const [highlighted, setHighlighted] = (0, _react.useState)(null);
      const [, addWarning] = (0, _StoreContext.useWarning)();
      const {
        validAnalyticsConnection
      } = (0, _react.useContext)(_ConnectionContext.default);
      const [{
        publishedToday
      }] = (0, _react.useContext)(_StoreContext.StoreContext);
      const [trafficSources, setTrafficSources] = (0, _frontendJsReactWeb.useStateSafe)([]);
      (0, _react.useEffect)(() => {
        if (validAnalyticsConnection) {
          dataProvider().then(response => setTrafficSources(response.trafficSources)).catch(() => {
            setTrafficSources([]);
            addWarning();
          });
        }
      }, [addWarning, dataProvider, setTrafficSources, validAnalyticsConnection]);
      const fullPieChart = (0, _react.useMemo)(() => trafficSources.some(({
        value
      }) => value), [trafficSources]);
      const missingTrafficSourceValue = (0, _react.useMemo)(() => trafficSources.some(({
        value
      }) => value === undefined), [trafficSources]);
      (0, _react.useEffect)(() => {
        if (missingTrafficSourceValue) {
          addWarning();
        }
      }, [addWarning, missingTrafficSourceValue]);

      function handleLegendMouseEnter(name) {
        setHighlighted(name);
      }

      function handleLegendMouseLeave() {
        setHighlighted(null);
      }

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h5", {
          className: "mt-3 sheet-subtitle"
        }, Liferay.Language.get('traffic-channels'), /*#__PURE__*/_react.default.createElement(_Hint.default, {
          message: Liferay.Language.get('traffic-channels-help'),
          secondary: true,
          title: Liferay.Language.get('traffic-channels')
        })), !fullPieChart && !missingTrafficSourceValue && /*#__PURE__*/_react.default.createElement("div", {
          className: "mb-3 text-secondary"
        }, Liferay.Language.get('your-page-has-no-incoming-traffic-from-traffic-channels-yet')), /*#__PURE__*/_react.default.createElement("div", {
          className: "pie-chart-wrapper"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "pie-chart-wrapper--legend"
        }, /*#__PURE__*/_react.default.createElement("table", null, /*#__PURE__*/_react.default.createElement("tbody", null, trafficSources.map(entry => {
          const hasDetails = (entry === null || entry === void 0 ? void 0 : entry.countryKeywords) || (entry === null || entry === void 0 ? void 0 : entry.referringPages) && (entry === null || entry === void 0 ? void 0 : entry.referringDomains) || (entry === null || entry === void 0 ? void 0 : entry.referringSocialMedia);
          return (/*#__PURE__*/_react.default.createElement("tr", {
              key: entry.name
            }, /*#__PURE__*/_react.default.createElement("td", {
              className: "px-0",
              onMouseOut: handleLegendMouseLeave,
              onMouseOver: () => handleLegendMouseEnter(entry.name)
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "pie-chart-wrapper--legend--dot",
              style: {
                backgroundColor: getColorByName(entry.name)
              }
            })), /*#__PURE__*/_react.default.createElement("td", {
              className: "c-py-1 text-secondary",
              onMouseOut: handleLegendMouseLeave,
              onMouseOver: () => handleLegendMouseEnter(entry.name)
            }, entry.value > 0 && hasDetails ? /*#__PURE__*/_react.default.createElement(_button.default, {
              className: "px-0 py-1 text-primary",
              displayType: "link",
              onClick: () => onTrafficSourceClick(trafficSources, entry.name),
              small: true
            }, entry.title) : /*#__PURE__*/_react.default.createElement("span", null, entry.title)), /*#__PURE__*/_react.default.createElement("td", {
              className: "text-secondary"
            }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
              message: entry.helpMessage,
              title: entry.title
            })), /*#__PURE__*/_react.default.createElement("td", {
              className: "font-weight-semi-bold"
            }, entry.value !== undefined && !publishedToday ? (0, _numberFormat.numberFormat)(languageTag, entry.value) : '-'))
          );
        })))), !fullPieChart && /*#__PURE__*/_react.default.createElement(_EmptyPieChart.default, {
          height: PIE_CHART_SIZES.height,
          innerRadius: PIE_CHART_SIZES.innerRadius,
          radius: PIE_CHART_SIZES.radius,
          width: PIE_CHART_SIZES.width
        }), fullPieChart && /*#__PURE__*/_react.default.createElement("div", {
          className: "pie-chart-wrapper--chart"
        }, /*#__PURE__*/_react.default.createElement(_recharts.PieChart, {
          height: PIE_CHART_SIZES.height,
          width: PIE_CHART_SIZES.width
        }, /*#__PURE__*/_react.default.createElement(_recharts.Pie, {
          cx: "50%",
          cy: "50%",
          data: trafficSources,
          dataKey: "value",
          innerRadius: PIE_CHART_SIZES.innerRadius,
          isAnimationActive: false,
          nameKey: 'name',
          outerRadius: PIE_CHART_SIZES.radius,
          paddingAngle: PIE_CHART_SIZES.paddingAngle
        }, trafficSources.map((entry, i) => {
          const fillColor = getColorByName(entry.name);
          const cellClasses = (0, _classnames.default)({
            dim: highlighted && entry.name !== highlighted
          });
          return (/*#__PURE__*/_react.default.createElement(_recharts.Cell, {
              className: cellClasses,
              fill: fillColor,
              key: i,
              onMouseOut: handleLegendMouseLeave,
              onMouseOver: () => handleLegendMouseEnter(entry.name)
            })
          );
        })), /*#__PURE__*/_react.default.createElement(_recharts.Tooltip, {
          animationDuration: 0,
          content: /*#__PURE__*/_react.default.createElement(TrafficSourcesCustomTooltip, null),
          formatter: (value, name, iconType) => {
            return [(0, _numberFormat.numberFormat)(languageTag, value), name, iconType];
          },
          separator: ': '
        })))))
      );
    }

    function TrafficSourcesCustomTooltip(props) {
      const {
        formatter,
        payload,
        separator = ''
      } = props;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "custom-tooltip"
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "mb-1 mt-0"
        }, /*#__PURE__*/_react.default.createElement("b", null, payload.length && payload[0].payload.title)), /*#__PURE__*/_react.default.createElement("ul", {
          className: "list-unstyled mb-0"
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, payload.map(item => {
          // eslint-disable-next-line no-unused-vars
          const [value, _name, iconType] = formatter ? formatter(item.value, item.name, item.iconType) : [item.value, item.name, item.iconType];
          const {
            payload
          } = item;
          return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
              key: item.name
            }, /*#__PURE__*/_react.default.createElement("li", null, Liferay.Language.get('visitors'), separator, /*#__PURE__*/_react.default.createElement("b", null, value)), /*#__PURE__*/_react.default.createElement("li", null, Liferay.Language.get('traffic-share'), separator, /*#__PURE__*/_react.default.createElement("b", null, "".concat(payload.share, "%"))))
          );
        }))))
      );
    }
    //# sourceMappingURL=TrafficSources.js.map
  }
});
//# sourceMappingURL=TrafficSources.js.map