Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/TotalCount", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ConnectionContext', '../context/StoreContext', '../utils/numberFormat', './Hint'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

    var _StoreContext = require("../context/StoreContext");

    var _numberFormat = require("../utils/numberFormat");

    var _Hint = _interopRequireDefault(require("./Hint"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function TotalCount({
      className,
      dataProvider,
      label,
      languageTag,
      percentage = false,
      popoverAlign,
      popoverHeader,
      popoverMessage,
      popoverPosition
    }) {
      const {
        validAnalyticsConnection
      } = (0, _react.useContext)(_ConnectionContext.default);
      const [value, setValue] = (0, _frontendJsReactWeb.useStateSafe)('-');
      const [, addWarning] = (0, _StoreContext.useWarning)();
      const [{
        publishedToday
      }] = (0, _react.useContext)(_StoreContext.StoreContext);
      (0, _react.useEffect)(() => {
        if (validAnalyticsConnection) {
          dataProvider().then(setValue).catch(() => {
            setValue('-');
            addWarning();
          });
        }
      }, [addWarning, dataProvider, setValue, validAnalyticsConnection]);
      let displayValue = '-';

      if (validAnalyticsConnection && !publishedToday) {
        displayValue = value !== '-' ? percentage ? /*#__PURE__*/_react.default.createElement("span", null, "".concat(value, "%")) : (0, _numberFormat.numberFormat)(languageTag, value) : value;
      }

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: className
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, label), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          align: popoverAlign,
          message: popoverMessage,
          position: popoverPosition,
          title: popoverHeader
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "font-weight-bold"
        }, displayValue))
      );
    }

    var _default = TotalCount;
    exports.default = _default;
    //# sourceMappingURL=TotalCount.js.map
  }
});
//# sourceMappingURL=TotalCount.js.map