Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/Navigation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ConnectionContext', '../context/StoreContext', '../utils/APIService', './Detail', './Main'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Navigation;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

    var _StoreContext = require("../context/StoreContext");

    var _APIService = _interopRequireDefault(require("../utils/APIService"));

    var _Detail = _interopRequireDefault(require("./Detail"));

    var _Main = _interopRequireDefault(require("./Main"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    const noop = () => {};

    function Navigation({
      author,
      canonicalURL,
      endpoints,
      languageTag,
      namespace,
      onSelectedLanguageClick = noop,
      page,
      pagePublishDate,
      pageTitle,
      timeSpanOptions,
      viewURLs
    }) {
      const [{
        historicalWarning,
        publishedToday,
        warning
      }] = (0, _react.useContext)(_StoreContext.StoreContext);
      const {
        validAnalyticsConnection
      } = (0, _react.useContext)(_ConnectionContext.default);
      const [currentPage, setCurrentPage] = (0, _react.useState)({
        view: 'main'
      });
      const [trafficSources, setTrafficSources] = (0, _react.useState)([]);
      const [trafficSourceName, setTrafficSourceName] = (0, _react.useState)('');
      const api = (0, _APIService.default)({
        endpoints,
        namespace,
        page
      });
      const {
        getHistoricalReads,
        getHistoricalViews,
        getTrafficSources
      } = api;
      const handleCurrentPage = (0, _react.useCallback)(currentPage => {
        setCurrentPage({
          view: currentPage.view
        });
      }, []);
      const handleTotalReads = (0, _react.useCallback)(() => {
        return api.getTotalReads().then(response => response.analyticsReportsTotalReads);
      }, [api]);
      const handleTotalViews = (0, _react.useCallback)(() => {
        return api.getTotalViews().then(response => response.analyticsReportsTotalViews);
      }, [api]);

      const handleTrafficShare = (0, _react.useCallback)(() => {
        var _trafficSource$share;

        const trafficSource = trafficSources.find(trafficSource => {
          return trafficSource.name === trafficSourceName;
        });
        return Promise.resolve((_trafficSource$share = trafficSource === null || trafficSource === void 0 ? void 0 : trafficSource.share) !== null && _trafficSource$share !== void 0 ? _trafficSource$share : '-');
      }, [trafficSourceName, trafficSources]);
      const handleTrafficVolume = (0, _react.useCallback)(() => {
        var _trafficSource$value;

        const trafficSource = trafficSources.find(trafficSource => {
          return trafficSource.name === trafficSourceName;
        });
        return Promise.resolve((_trafficSource$value = trafficSource === null || trafficSource === void 0 ? void 0 : trafficSource.value) !== null && _trafficSource$value !== void 0 ? _trafficSource$value : '-');
      }, [trafficSourceName, trafficSources]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !validAnalyticsConnection && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "danger",
          variant: "stripe"
        }, Liferay.Language.get('an-unexpected-error-occurred')), validAnalyticsConnection && (historicalWarning || warning) && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "warning",
          variant: "stripe"
        }, Liferay.Language.get('some-data-is-temporarily-unavailable')), validAnalyticsConnection && publishedToday && !historicalWarning && !warning && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "info",
          title: Liferay.Language.get('no-data-is-available-yet'),
          variant: "stripe"
        }, Liferay.Language.get('content-has-just-been-published')), currentPage.view === 'main' && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_Main.default, {
          author: author,
          canonicalURL: canonicalURL,
          chartDataProviders: [getHistoricalViews, getHistoricalReads],
          languageTag: languageTag,
          onSelectedLanguageClick: onSelectedLanguageClick,
          onTrafficSourceClick: (trafficSources, trafficSourceName) => {
            setTrafficSources(trafficSources);
            setTrafficSourceName(trafficSourceName);
            const trafficSource = trafficSources.find(trafficSource => {
              return trafficSource.name === trafficSourceName;
            });
            setCurrentPage({
              data: trafficSource,
              view: trafficSource.name
            });
          },
          pagePublishDate: pagePublishDate,
          pageTitle: pageTitle,
          timeSpanOptions: timeSpanOptions,
          totalReadsDataProvider: handleTotalReads,
          totalViewsDataProvider: handleTotalViews,
          trafficSourcesDataProvider: getTrafficSources,
          viewURLs: viewURLs
        })), currentPage.view !== 'main' && /*#__PURE__*/_react.default.createElement(_Detail.default, {
          currentPage: currentPage,
          languageTag: languageTag,
          onCurrentPageChange: handleCurrentPage,
          onTrafficSourceNameChange: trafficSourceName => setTrafficSourceName(trafficSourceName),
          timeSpanOptions: timeSpanOptions,
          trafficShareDataProvider: handleTrafficShare,
          trafficVolumeDataProvider: handleTrafficVolume
        }))
      );
    }

    Navigation.proptypes = {
      author: _propTypes.default.object.isRequired,
      canonicalURL: _propTypes.default.string.isRequired,
      endpoints: _propTypes.default.object.isRequired,
      languageTag: _propTypes.default.string.isRequired,
      namespace: _propTypes.default.string.isRequired,
      onSelectedLanguageClick: _propTypes.default.func.isRequired,
      page: _propTypes.default.objectOf(_propTypes.default.shape({
        plid: _propTypes.default.number.isRequired
      })).isRequired,
      pagePublishDate: _propTypes.default.string.isRequired,
      pageTitle: _propTypes.default.string.isRequired,
      timeSpanOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
        key: _propTypes.default.string.isRequired,
        label: _propTypes.default.string.isRequired
      })).isRequired,
      viewURLs: _propTypes.default.arrayOf(_propTypes.default.shape({
        default: _propTypes.default.bool.isRequired,
        languageId: _propTypes.default.string.isRequired,
        selected: _propTypes.default.bool.isRequired,
        viewURL: _propTypes.default.string.isRequired
      })).isRequired
    };
    //# sourceMappingURL=Navigation.js.map
  }
});
//# sourceMappingURL=Navigation.js.map