Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/Keywords", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/StoreContext', '../utils/numberFormat', './Hint'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Keywords;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _StoreContext = require("../context/StoreContext");

    var _numberFormat = require("../utils/numberFormat");

    var _Hint = _interopRequireDefault(require("./Hint"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    const KEYWORD_VALUE_TYPE = [{
      label: Liferay.Language.get('traffic'),
      name: 'traffic'
    }, {
      label: Liferay.Language.get('search-volume'),
      name: 'volume'
    }, {
      label: Liferay.Language.get('position'),
      name: 'position'
    }];

    function Keywords({
      currentPage,
      languageTag
    }) {
      const [isDropdownOpen, setIsDropdownOpen] = (0, _react.useState)(false);
      const [keywordValueType, setKeywordValueType] = (0, _react.useState)(KEYWORD_VALUE_TYPE[0]);
      const [{
        publishedToday
      }] = (0, _react.useContext)(_StoreContext.StoreContext);
      const countries = (0, _react.useMemo)(() => {
        const dataKeys = new Set();
        return currentPage.data.countryKeywords.reduce((acc, {
          countryCode,
          countryName
        }) => {
          if (dataKeys.has(countryCode)) {
            return acc;
          }

          dataKeys.add(countryCode);
          return acc.concat({
            countryCode,
            countryName
          });
        }, []);
      }, [currentPage.data.countryKeywords]);
      const [currentCountry, setCurrentCountry] = (0, _react.useState)(countries[0].countryCode);
      const keywords = (0, _react.useMemo)(() => {
        var _countryKeywords$keyw;

        const countryKeywords = currentCountry && currentPage.data.countryKeywords.find(country => {
          return country.countryCode === currentCountry;
        });
        return (_countryKeywords$keyw = countryKeywords === null || countryKeywords === void 0 ? void 0 : countryKeywords.keywords) !== null && _countryKeywords$keyw !== void 0 ? _countryKeywords$keyw : [];
      }, [currentPage.data.countryKeywords, currentCountry]);

      const handleKeywordValueType = valueTypeName => {
        const newKeywordValueType = KEYWORD_VALUE_TYPE.find(keywordValueType => {
          return keywordValueType.name === valueTypeName;
        });
        setKeywordValueType(newKeywordValueType);
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("h5", {
          className: "mt-3 sheet-subtitle"
        }, Liferay.Language.get('best-keywords')), /*#__PURE__*/_react.default.createElement("div", {
          className: "mb-3 text-secondary"
        }, Liferay.Language.get('best-keywords-description')), /*#__PURE__*/_react.default.createElement("div", {
          className: "form-group"
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: "countrySelect"
        }, Liferay.Language.get('select-country')), /*#__PURE__*/_react.default.createElement(_form.ClaySelect, {
          "aria-label": Liferay.Language.get('select-country'),
          className: "bg-white",
          defaultValue: currentCountry,
          id: "countrySelect",
          onChange: event => {
            const country = event.target.value;
            setCurrentCountry(country);
          }
        }, countries.map(item => /*#__PURE__*/_react.default.createElement(_form.ClaySelect.Option, {
          key: item.countryCode,
          label: item.countryName,
          value: item.countryCode
        })))), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "list-group-keywords-list"
        }, /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, {
          className: "text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, Liferay.Language.get('best-keyword'), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          message: Liferay.Language.get('best-keyword-help'),
          title: Liferay.Language.get('best-keyword')
        }))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: isDropdownOpen,
          onActiveChange: setIsDropdownOpen,
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            className: "px-0 text-body",
            displayType: "link",
            small: true
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "font-weight-semi-bold"
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "pr-2"
          }, keywordValueType.label), /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "caret-bottom"
          })))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, KEYWORD_VALUE_TYPE.map((valueType, index) => /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          active: valueType.name === keywordValueType.name,
          key: index,
          onClick: () => {
            handleKeywordValueType(valueType.name);
            setIsDropdownOpen(false);
          }
        }, valueType.label)))))), !publishedToday && keywords.map(({
          keyword,
          position,
          searchVolume,
          traffic
        }) => {
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true,
              key: keyword
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
              className: "text-truncate-inline",
              "data-tooltip-align": "top",
              title: keyword
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "text-secondary text-truncate"
            }, keyword))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "align-self-end font-weight-semi-bold text-dark"
            }, (0, _numberFormat.numberFormat)(languageTag, keywordValueType.name === 'traffic' ? traffic : keywordValueType.name === 'volume' ? searchVolume : position))))
          );
        }), (publishedToday || keywords.length === 0) && /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, Liferay.Language.get('there-are-no-best-keywords-yet')))))))
      );
    }

    Keywords.proptypes = {
      currentPage: _propTypes.default.object.isRequired,
      languageTag: _propTypes.default.string.isRequired
    };
    //# sourceMappingURL=Keywords.js.map
  }
});
//# sourceMappingURL=Keywords.js.map