Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/Hint", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './Popover'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Hint;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Popover = _interopRequireDefault(require("./Popover"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function Hint({
      align,
      message,
      position,
      secondary,
      title
    }) {
      const iconRef = (0, _react.useRef)();
      const [showTooltip, setShowTooltip] = (0, _react.useState)(false);

      const hintClasses = (0, _classnames.default)('p-1', 'small', {
        'text-secondary': secondary
      });
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
          className: hintClasses,
          onMouseEnter: () => {
            setShowTooltip(true);
          },
          onMouseLeave: () => {
            setShowTooltip(false);
          },
          ref: iconRef
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "mr-1",
          small: "true",
          symbol: "question-circle"
        })), showTooltip && /*#__PURE__*/_react.default.createElement(_Popover.default, {
          align: align,
          anchor: iconRef.current,
          header: title,
          position: position
        }, message))
      );
    }

    Hint.proptypes = {
      message: _propTypes.default.string.isRequired,
      title: _propTypes.default.string.isRequired
    };
    //# sourceMappingURL=Hint.js.map
  }
});
//# sourceMappingURL=Hint.js.map