Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/Detail", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './detail/KeywordsDetail', './detail/ReferralDetail', './detail/SocialDetail'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Detail;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _KeywordsDetail = _interopRequireDefault(require("./detail/KeywordsDetail"));

    var _ReferralDetail = _interopRequireDefault(require("./detail/ReferralDetail"));

    var _SocialDetail = _interopRequireDefault(require("./detail/SocialDetail"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    const TRAFFIC_CHANNELS = {
      DIRECT: 'direct',
      ORGANIC: 'organic',
      PAID: 'paid',
      REFERRAL: 'referral',
      SOCIAL: 'social'
    };

    function Detail({
      currentPage,
      languageTag,
      onCurrentPageChange,
      onTrafficSourceNameChange,
      timeSpanOptions,
      trafficShareDataProvider,
      trafficVolumeDataProvider
    }) {
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "c-pt-3 c-px-3 d-flex"
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          displayType: "unstyled",
          onClick: () => {
            onCurrentPageChange({
              view: 'main'
            });
            onTrafficSourceNameChange('');
          },
          small: true
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "angle-left-small"
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "align-self-center flex-grow-1 mx-2"
        }, /*#__PURE__*/_react.default.createElement("strong", null, currentPage.data.title))), (currentPage.view === TRAFFIC_CHANNELS.ORGANIC || currentPage.view === TRAFFIC_CHANNELS.PAID) && currentPage.data.countryKeywords.length > 0 && /*#__PURE__*/_react.default.createElement(_KeywordsDetail.default, {
          currentPage: currentPage,
          languageTag: languageTag,
          trafficShareDataProvider: trafficShareDataProvider,
          trafficVolumeDataProvider: trafficVolumeDataProvider
        }), currentPage.view === TRAFFIC_CHANNELS.REFERRAL && /*#__PURE__*/_react.default.createElement(_ReferralDetail.default, {
          currentPage: currentPage,
          languageTag: languageTag,
          timeSpanOptions: timeSpanOptions,
          trafficShareDataProvider: trafficShareDataProvider,
          trafficVolumeDataProvider: trafficVolumeDataProvider
        }), currentPage.view === TRAFFIC_CHANNELS.SOCIAL && /*#__PURE__*/_react.default.createElement(_SocialDetail.default, {
          currentPage: currentPage,
          languageTag: languageTag,
          timeSpanOptions: timeSpanOptions,
          trafficShareDataProvider: trafficShareDataProvider,
          trafficVolumeDataProvider: trafficVolumeDataProvider
        }))
      );
    }

    Detail.proptypes = {
      currentPage: _propTypes.default.object.isRequired,
      languageTag: _propTypes.default.string.isRequired,
      onCurrentPageChange: _propTypes.default.func.isRequired,
      onTrafficSourceNameChange: _propTypes.default.func.isRequired,
      timeSpanOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
        key: _propTypes.default.string,
        label: _propTypes.default.string
      })).isRequired,
      trafficShareDataProvider: _propTypes.default.func.isRequired,
      trafficVolumeDataProvider: _propTypes.default.func.isRequired
    };
    //# sourceMappingURL=Detail.js.map
  }
});
//# sourceMappingURL=Detail.js.map