Liferay.Loader.define("analytics-reports-web@1.0.49/js/components/CustomTooltip", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = CustomTooltip;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */

    /**
     * Component to customize the content of recharts Tooltip
     * http://recharts.org/en-US/api/Tooltip#content
     */
    function CustomTooltip(props) {
      const {
        formatter,
        label,
        labelFormatter,
        payload,
        publishDateFill,
        separator = '',
        showPublishedDateLabel
      } = props;
      return label ? /*#__PURE__*/_react.default.createElement("div", {
        className: "custom-tooltip"
      }, /*#__PURE__*/_react.default.createElement("p", {
        className: "mb-1 mt-0"
      }, /*#__PURE__*/_react.default.createElement("b", null, labelFormatter ? labelFormatter(label) : label)), /*#__PURE__*/_react.default.createElement("hr", {
        className: "mb-1 mt-1"
      }), showPublishedDateLabel && /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("span", {
        className: 'custom-circle mr-1',
        style: {
          backgroundColor: 'white',
          border: "2px solid ".concat(publishDateFill)
        }
      }), Liferay.Language.get('published')), /*#__PURE__*/_react.default.createElement("ul", {
        className: "list-unstyled mb-0"
      }, payload.map(item => {
        const [value, name, iconType] = formatter ? formatter(item.value, item.name, item.iconType) : [item.value, item.name, item.iconType];
        return (/*#__PURE__*/_react.default.createElement("li", {
            key: item.name
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "custom-".concat(iconType, " mr-1"),
            style: {
              backgroundColor: item.color
            }
          }), name, separator, /*#__PURE__*/_react.default.createElement("b", null, value))
        );
      }))) : null;
    }
    //# sourceMappingURL=CustomTooltip.js.map
  }
});
//# sourceMappingURL=CustomTooltip.js.map