Liferay.Loader.define('analytics-reports-web$lodash-es@4.17.15/upperCase', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import createCompounder from './_createCompounder.js';

    /**
     * Converts `string`, as space separated words, to upper case.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the upper cased string.
     * @example
     *
     * _.upperCase('--foo-bar');
     * // => 'FOO BAR'
     *
     * _.upperCase('fooBar');
     * // => 'FOO BAR'
     *
     * _.upperCase('__foo_bar__');
     * // => 'FOO BAR'
     */
    var upperCase = createCompounder(function (result, word, index) {
      return result + (index ? ' ' : '') + word.toUpperCase();
    });

    export default upperCase;
  }
});
//# sourceMappingURL=upperCase.js.map