Liferay.Loader.define("analytics-reports-web@1.0.45/js/components/TotalCount", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ConnectionContext', '../context/StoreContext', '../utils/numberFormat', './Hint'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

    var _StoreContext = require("../context/StoreContext");

    var _numberFormat = require("../utils/numberFormat");

    var _Hint = _interopRequireDefault(require("./Hint"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function TotalCount(_ref) {
      var className = _ref.className,
          dataProvider = _ref.dataProvider,
          label = _ref.label,
          languageTag = _ref.languageTag,
          _ref$percentage = _ref.percentage,
          percentage = _ref$percentage === void 0 ? false : _ref$percentage,
          popoverAlign = _ref.popoverAlign,
          popoverHeader = _ref.popoverHeader,
          popoverMessage = _ref.popoverMessage,
          popoverPosition = _ref.popoverPosition;

      var _useContext = (0, _react.useContext)(_ConnectionContext.default),
          validAnalyticsConnection = _useContext.validAnalyticsConnection;

      var _useStateSafe = (0, _frontendJsReactWeb.useStateSafe)('-'),
          _useStateSafe2 = _slicedToArray(_useStateSafe, 2),
          value = _useStateSafe2[0],
          setValue = _useStateSafe2[1];

      var _useWarning = (0, _StoreContext.useWarning)(),
          _useWarning2 = _slicedToArray(_useWarning, 2),
          addWarning = _useWarning2[1];

      var _useContext2 = (0, _react.useContext)(_StoreContext.StoreContext),
          _useContext3 = _slicedToArray(_useContext2, 1),
          publishedToday = _useContext3[0].publishedToday;

      (0, _react.useEffect)(function () {
        if (validAnalyticsConnection) {
          dataProvider().then(setValue).catch(function () {
            setValue('-');
            addWarning();
          });
        }
      }, [addWarning, dataProvider, setValue, validAnalyticsConnection]);
      var displayValue = '-';

      if (validAnalyticsConnection && !publishedToday) {
        displayValue = value !== '-' ? percentage ? /*#__PURE__*/_react.default.createElement("span", null, "".concat(value, "%")) : (0, _numberFormat.numberFormat)(languageTag, value) : value;
      }

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: className
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, label), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          align: popoverAlign,
          message: popoverMessage,
          position: popoverPosition,
          title: popoverHeader
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "font-weight-bold"
        }, displayValue))
      );
    }

    var _default = TotalCount;
    exports.default = _default;
    //# sourceMappingURL=TotalCount.js.map
  }
});
//# sourceMappingURL=TotalCount.js.map