Liferay.Loader.define("analytics-reports-web@1.0.44/js/components/BasicInformation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/sticker', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames2 = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function Author(_ref) {
      var _ref$author = _ref.author,
          authorId = _ref$author.authorId,
          name = _ref$author.name,
          url = _ref$author.url;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_sticker.default, {
          className: (0, _classnames2.default)('c-mr-2 sticker-user-icon', _defineProperty({}, "user-icon-color-".concat(parseInt(authorId, 10) % 10), !url)),
          shape: "circle",
          size: "sm"
        }, url ? /*#__PURE__*/_react.default.createElement("img", {
          alt: "".concat(name, "."),
          className: "sticker-img",
          src: url
        }) : /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "user"
        })), Liferay.Util.sub(Liferay.Language.get('authored-by-x'), name))
      );
    }

    function BasicInformation(_ref2) {
      var author = _ref2.author,
          canonicalURL = _ref2.canonicalURL,
          languageTag = _ref2.languageTag,
          publishDate = _ref2.publishDate,
          title = _ref2.title;
      var formattedPublishDate = Intl.DateTimeFormat(languageTag, {
        day: 'numeric',
        month: 'long',
        year: 'numeric'
      }).format(new Date(publishDate));
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "sidebar-section"
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
          className: "component-title text-truncate-inline",
          "data-tooltip-align": "top",
          title: title
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, title))))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate-inline",
          "data-tooltip-align": "top",
          title: canonicalURL
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "c-mb-2 c-mt-1 text-secondary text-truncate text-truncate-reverse"
        }, canonicalURL))))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "text-secondary"
        }, Liferay.Util.sub(Liferay.Language.get('published-on-x'), formattedPublishDate)))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(Author, {
          author: author
        }))))
      );
    }

    var _default = BasicInformation;
    exports.default = _default;
    //# sourceMappingURL=BasicInformation.js.map
  }
});
//# sourceMappingURL=BasicInformation.js.map