Liferay.Loader.define("analytics-reports-web@1.0.41/js/components/Navigation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ConnectionContext', '../context/StoreContext', '../utils/APIService', './Detail', './Main'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Navigation;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

    var _StoreContext = require("../context/StoreContext");

    var _APIService = _interopRequireDefault(require("../utils/APIService"));

    var _Detail = _interopRequireDefault(require("./Detail"));

    var _Main = _interopRequireDefault(require("./Main"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var noop = function noop() {};

    function Navigation(_ref) {
      var author = _ref.author,
          canonicalURL = _ref.canonicalURL,
          endpoints = _ref.endpoints,
          languageTag = _ref.languageTag,
          namespace = _ref.namespace,
          _ref$onSelectedLangua = _ref.onSelectedLanguageClick,
          onSelectedLanguageClick = _ref$onSelectedLangua === void 0 ? noop : _ref$onSelectedLangua,
          page = _ref.page,
          pagePublishDate = _ref.pagePublishDate,
          pageTitle = _ref.pageTitle,
          timeSpanOptions = _ref.timeSpanOptions,
          viewURLs = _ref.viewURLs;

      var _useContext = (0, _react.useContext)(_StoreContext.StoreContext),
          _useContext2 = _slicedToArray(_useContext, 1),
          _useContext2$ = _useContext2[0],
          historicalWarning = _useContext2$.historicalWarning,
          publishedToday = _useContext2$.publishedToday,
          warning = _useContext2$.warning;

      var _useContext3 = (0, _react.useContext)(_ConnectionContext.default),
          validAnalyticsConnection = _useContext3.validAnalyticsConnection;

      var _useState = (0, _react.useState)({
        view: 'main'
      }),
          _useState2 = _slicedToArray(_useState, 2),
          currentPage = _useState2[0],
          setCurrentPage = _useState2[1];

      var _useState3 = (0, _react.useState)([]),
          _useState4 = _slicedToArray(_useState3, 2),
          trafficSources = _useState4[0],
          setTrafficSources = _useState4[1];

      var _useState5 = (0, _react.useState)(''),
          _useState6 = _slicedToArray(_useState5, 2),
          trafficSourceName = _useState6[0],
          setTrafficSourceName = _useState6[1];

      var api = (0, _APIService.default)({
        endpoints: endpoints,
        namespace: namespace,
        page: page
      });
      var getHistoricalReads = api.getHistoricalReads,
          getHistoricalViews = api.getHistoricalViews,
          getTrafficSources = api.getTrafficSources;
      var handleCurrentPage = (0, _react.useCallback)(function (currentPage) {
        setCurrentPage({
          view: currentPage.view
        });
      }, []);
      var handleTotalReads = (0, _react.useCallback)(function () {
        return api.getTotalReads().then(function (response) {
          return response.analyticsReportsTotalReads;
        });
      }, [api]);
      var handleTotalViews = (0, _react.useCallback)(function () {
        return api.getTotalViews().then(function (response) {
          return response.analyticsReportsTotalViews;
        });
      }, [api]);

      var handleTrafficShare = (0, _react.useCallback)(function () {
        var _trafficSource$share;

        var trafficSource = trafficSources.find(function (trafficSource) {
          return trafficSource.name === trafficSourceName;
        });
        return Promise.resolve((_trafficSource$share = trafficSource === null || trafficSource === void 0 ? void 0 : trafficSource.share) !== null && _trafficSource$share !== void 0 ? _trafficSource$share : '-');
      }, [trafficSourceName, trafficSources]);
      var handleTrafficVolume = (0, _react.useCallback)(function () {
        var _trafficSource$value;

        var trafficSource = trafficSources.find(function (trafficSource) {
          return trafficSource.name === trafficSourceName;
        });
        return Promise.resolve((_trafficSource$value = trafficSource === null || trafficSource === void 0 ? void 0 : trafficSource.value) !== null && _trafficSource$value !== void 0 ? _trafficSource$value : '-');
      }, [trafficSourceName, trafficSources]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !validAnalyticsConnection && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "danger",
          variant: "stripe"
        }, Liferay.Language.get('an-unexpected-error-occurred')), validAnalyticsConnection && (historicalWarning || warning) && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "warning",
          variant: "stripe"
        }, Liferay.Language.get('some-data-is-temporarily-unavailable')), validAnalyticsConnection && publishedToday && !historicalWarning && !warning && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "info",
          title: Liferay.Language.get('no-data-is-available-yet'),
          variant: "stripe"
        }, Liferay.Language.get('content-has-just-been-published')), currentPage.view === 'main' && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_Main.default, {
          author: author,
          canonicalURL: canonicalURL,
          chartDataProviders: [getHistoricalViews, getHistoricalReads],
          languageTag: languageTag,
          onSelectedLanguageClick: onSelectedLanguageClick,
          onTrafficSourceClick: function handleTrafficSourceClick(trafficSources, trafficSourceName) {
            setTrafficSources(trafficSources);
            setTrafficSourceName(trafficSourceName);
            var trafficSource = trafficSources.find(function (trafficSource) {
              return trafficSource.name === trafficSourceName;
            });
            setCurrentPage({
              data: trafficSource,
              view: trafficSource.name
            });
          },
          pagePublishDate: pagePublishDate,
          pageTitle: pageTitle,
          timeSpanOptions: timeSpanOptions,
          totalReadsDataProvider: handleTotalReads,
          totalViewsDataProvider: handleTotalViews,
          trafficSourcesDataProvider: getTrafficSources,
          viewURLs: viewURLs
        })), currentPage.view !== 'main' && /*#__PURE__*/_react.default.createElement(_Detail.default, {
          currentPage: currentPage,
          languageTag: languageTag,
          onCurrentPageChange: handleCurrentPage,
          onTrafficSourceNameChange: function handleTrafficSourceName(trafficSourceName) {
            return setTrafficSourceName(trafficSourceName);
          },
          timeSpanOptions: timeSpanOptions,
          trafficShareDataProvider: handleTrafficShare,
          trafficVolumeDataProvider: handleTrafficVolume
        }))
      );
    }

    Navigation.proptypes = {
      author: _propTypes.default.object.isRequired,
      canonicalURL: _propTypes.default.string.isRequired,
      endpoints: _propTypes.default.object.isRequired,
      languageTag: _propTypes.default.string.isRequired,
      namespace: _propTypes.default.string.isRequired,
      onSelectedLanguageClick: _propTypes.default.func.isRequired,
      page: _propTypes.default.objectOf(_propTypes.default.shape({
        plid: _propTypes.default.number.isRequired
      })).isRequired,
      pagePublishDate: _propTypes.default.string.isRequired,
      pageTitle: _propTypes.default.string.isRequired,
      timeSpanOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
        key: _propTypes.default.string.isRequired,
        label: _propTypes.default.string.isRequired
      })).isRequired,
      viewURLs: _propTypes.default.arrayOf(_propTypes.default.shape({
        default: _propTypes.default.bool.isRequired,
        languageId: _propTypes.default.string.isRequired,
        selected: _propTypes.default.bool.isRequired,
        viewURL: _propTypes.default.string.isRequired
      })).isRequired
    };
    //# sourceMappingURL=Navigation.js.map
  }
});
//# sourceMappingURL=Navigation.js.map