Liferay.Loader.define("analytics-reports-web@1.0.4/js/AnalyticsReportsApp", ['module', 'exports', 'require', 'frontend-js-react-web$react', './components/Navigation', './context/ConnectionContext', './context/store', './utils/APIService'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = _default;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _Navigation = _interopRequireDefault(require("./components/Navigation"));

  var _ConnectionContext = _interopRequireDefault(require("./context/ConnectionContext"));

  var _store = require("./context/store");

  var _APIService = _interopRequireDefault(require("./utils/APIService"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * The contents of this file are subject to the terms of the Liferay Enterprise
   * Subscription License ("License"). You may not use this file except in
   * compliance with the License. You can obtain a copy of the License by
   * contacting Liferay, Inc. See the License for the specific language governing
   * permissions and limitations under the License, including but not limited to
   * distribution rights of the Software.
   */
  function _default(_ref) {
    var context = _ref.context,
        props = _ref.props;
    var languageTag = context.languageTag,
        namespace = context.namespace,
        page = context.page;
    var defaultTimeRange = context.defaultTimeRange,
        defaultTimeSpanKey = context.defaultTimeSpanKey,
        timeSpans = context.timeSpans;
    var validAnalyticsConnection = context.validAnalyticsConnection;
    var readsEnabled = context.readsEnabled;
    var authorName = props.authorName,
        publishDate = props.publishDate,
        title = props.title;
    var trafficSources = props.trafficSources;
    var _context$endpoints = context.endpoints,
        getAnalyticsReportsHistoricalReadsURL = _context$endpoints.getAnalyticsReportsHistoricalReadsURL,
        getAnalyticsReportsHistoricalViewsURL = _context$endpoints.getAnalyticsReportsHistoricalViewsURL,
        getAnalyticsReportsTotalReadsURL = _context$endpoints.getAnalyticsReportsTotalReadsURL,
        getAnalyticsReportsTotalViewsURL = _context$endpoints.getAnalyticsReportsTotalViewsURL;
    var api = (0, _APIService["default"])({
      endpoints: {
        getAnalyticsReportsHistoricalReadsURL: getAnalyticsReportsHistoricalReadsURL,
        getAnalyticsReportsHistoricalViewsURL: getAnalyticsReportsHistoricalViewsURL,
        getAnalyticsReportsTotalReadsURL: getAnalyticsReportsTotalReadsURL,
        getAnalyticsReportsTotalViewsURL: getAnalyticsReportsTotalViewsURL
      },
      namespace: namespace,
      page: page
    });
    var publishedToday = new Date().toDateString() === new Date(publishDate).toDateString();
    return _react["default"].createElement(_ConnectionContext["default"].Provider, {
      value: {
        validAnalyticsConnection: validAnalyticsConnection
      }
    }, _react["default"].createElement(_store.StoreContextProvider, {
      value: {
        publishedToday: publishedToday,
        readsEnabled: readsEnabled
      }
    }, _react["default"].createElement(_Navigation["default"], {
      api: api,
      authorName: authorName,
      defaultTimeRange: defaultTimeRange,
      defaultTimeSpanKey: defaultTimeSpanKey,
      languageTag: languageTag,
      pagePublishDate: publishDate,
      pageTitle: title,
      timeSpanOptions: timeSpans,
      trafficSources: trafficSources
    })));
  }
  //# sourceMappingURL=AnalyticsReportsApp.js.map
});
//# sourceMappingURL=AnalyticsReportsApp.js.map