Liferay.Loader.define("analytics-reports-web@1.0.32/js/components/Main", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './BasicInformation', './Chart', './TotalCount', './TrafficSources', './Translation'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Main;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _BasicInformation = _interopRequireDefault(require("./BasicInformation"));

    var _Chart = _interopRequireDefault(require("./Chart"));

    var _TotalCount = _interopRequireDefault(require("./TotalCount"));

    var _TrafficSources = _interopRequireDefault(require("./TrafficSources"));

    var _Translation = _interopRequireDefault(require("./Translation"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function Main(_ref) {
      var author = _ref.author,
          canonicalURL = _ref.canonicalURL,
          chartDataProviders = _ref.chartDataProviders,
          languageTag = _ref.languageTag,
          onSelectedLanguageClick = _ref.onSelectedLanguageClick,
          onTrafficSourceClick = _ref.onTrafficSourceClick,
          pagePublishDate = _ref.pagePublishDate,
          pageTitle = _ref.pageTitle,
          timeSpanOptions = _ref.timeSpanOptions,
          totalReadsDataProvider = _ref.totalReadsDataProvider,
          totalViewsDataProvider = _ref.totalViewsDataProvider,
          trafficSourcesDataProvider = _ref.trafficSourcesDataProvider,
          viewURLs = _ref.viewURLs;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "c-p-3"
        }, /*#__PURE__*/_react.default.createElement(_BasicInformation.default, {
          author: author,
          canonicalURL: canonicalURL,
          languageTag: languageTag,
          publishDate: pagePublishDate,
          title: pageTitle
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "mt-4"
        }, /*#__PURE__*/_react.default.createElement(_Translation.default, {
          defaultLanguage: languageTag,
          onSelectedLanguageClick: onSelectedLanguageClick,
          viewURLs: viewURLs
        })), /*#__PURE__*/_react.default.createElement("h5", {
          className: "mt-3 sheet-subtitle"
        }, Liferay.Language.get('engagement')), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "mb-2",
          dataProvider: totalViewsDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('total-views')),
          languageTag: languageTag,
          popoverHeader: Liferay.Language.get('total-views'),
          popoverMessage: Liferay.Language.get('this-number-refers-to-the-total-number-of-views-since-the-content-was-published')
        }), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          dataProvider: totalReadsDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('total-reads')),
          languageTag: languageTag,
          popoverHeader: Liferay.Language.get('total-reads'),
          popoverMessage: Liferay.Language.get('this-number-refers-to-the-total-number-of-reads-since-the-content-was-published')
        }), /*#__PURE__*/_react.default.createElement(_Chart.default, {
          dataProviders: chartDataProviders,
          languageTag: languageTag,
          publishDate: pagePublishDate,
          timeSpanOptions: timeSpanOptions
        }), /*#__PURE__*/_react.default.createElement(_TrafficSources.default, {
          dataProvider: trafficSourcesDataProvider,
          languageTag: languageTag,
          onTrafficSourceClick: onTrafficSourceClick
        }))
      );
    }

    Main.proptypes = {
      author: _propTypes.default.object.isRequired,
      canonicalURL: _propTypes.default.string.isRequired,
      chartDataProviders: _propTypes.default.arrayOf(_propTypes.default.func.isRequired).isRequired,
      languageTag: _propTypes.default.string.isRequired,
      onSelectedLanguageClick: _propTypes.default.func.isRequired,
      onTrafficSourceClick: _propTypes.default.func.isRequired,
      pagePublishDate: _propTypes.default.string.isRequired,
      pageTitle: _propTypes.default.string.isRequired,
      timeSpanOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
        key: _propTypes.default.string,
        label: _propTypes.default.string
      })).isRequired,
      totalReadsDataProvider: _propTypes.default.func.isRequired,
      totalViewsDataProvider: _propTypes.default.func.isRequired,
      trafficSourcesDataProvider: _propTypes.default.func.isRequired,
      viewURLs: _propTypes.default.arrayOf(_propTypes.default.shape({
        default: _propTypes.default.bool.isRequired,
        languageId: _propTypes.default.string.isRequired,
        selected: _propTypes.default.bool.isRequired,
        viewURL: _propTypes.default.string.isRequired
      })).isRequired
    };
    //# sourceMappingURL=Main.js.map
  }
});
//# sourceMappingURL=Main.js.map