Liferay.Loader.define('analytics-reports-web$lodash-es@4.17.15/sortedUniq', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseSortedUniq from './_baseSortedUniq.js';

  /**
   * This method is like `_.uniq` except that it's designed and optimized
   * for sorted arrays.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {Array} array The array to inspect.
   * @returns {Array} Returns the new duplicate free array.
   * @example
   *
   * _.sortedUniq([1, 1, 2]);
   * // => [1, 2]
   */
  function sortedUniq(array) {
    return array && array.length ? baseSortedUniq(array) : [];
  }

  export default sortedUniq;
});
//# sourceMappingURL=sortedUniq.js.map