Liferay.Loader.define("analytics-reports-web@1.0.3/js/components/Navigation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ConnectionContext', '../context/store', '../utils/numberFormat', './Detail', './Main'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = Navigation;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

  var _store = require("../context/store");

  var _numberFormat = require("../utils/numberFormat");

  var _Detail = _interopRequireDefault(require("./Detail"));

  var _Main = _interopRequireDefault(require("./Main"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function Navigation(_ref) {
    var api = _ref.api,
        authorName = _ref.authorName,
        defaultTimeRange = _ref.defaultTimeRange,
        defaultTimeSpanKey = _ref.defaultTimeSpanKey,
        languageTag = _ref.languageTag,
        pagePublishDate = _ref.pagePublishDate,
        pageTitle = _ref.pageTitle,
        timeSpanOptions = _ref.timeSpanOptions,
        trafficSources = _ref.trafficSources;

    var _useState = (0, _react.useState)({
      view: 'main'
    }),
        _useState2 = _slicedToArray(_useState, 2),
        currentPage = _useState2[0],
        setCurrentPage = _useState2[1];

    var _useState3 = (0, _react.useState)(''),
        _useState4 = _slicedToArray(_useState3, 2),
        trafficSourceName = _useState4[0],
        setTrafficSourceName = _useState4[1];

    var _useContext = (0, _react.useContext)(_ConnectionContext["default"]),
        validAnalyticsConnection = _useContext.validAnalyticsConnection;

    var _useWarning = (0, _store.useWarning)(),
        _useWarning2 = _slicedToArray(_useWarning, 1),
        hasWarning = _useWarning2[0];

    var _useHistoricalWarning = (0, _store.useHistoricalWarning)(),
        _useHistoricalWarning2 = _slicedToArray(_useHistoricalWarning, 1),
        hasHistoricalWarning = _useHistoricalWarning2[0];

    var getHistoricalReads = api.getHistoricalReads,
        getHistoricalViews = api.getHistoricalViews;
    var handleCurrentPage = (0, _react.useCallback)(function (currentPage) {
      setCurrentPage({
        view: currentPage.view
      });
    }, []);
    var handleTotalReads = (0, _react.useCallback)(function () {
      return api.getTotalReads().then(function (response) {
        return (0, _numberFormat.numberFormat)(languageTag, response.analyticsReportsTotalReads);
      });
    }, [api, languageTag]);
    var handleTotalViews = (0, _react.useCallback)(function () {
      return api.getTotalViews().then(function (response) {
        return (0, _numberFormat.numberFormat)(languageTag, response.analyticsReportsTotalViews);
      });
    }, [api, languageTag]);
    var handleTrafficShare = (0, _react.useCallback)(function () {
      var _ref2;

      var trafficSource = trafficSources.find(function (trafficSource) {
        return trafficSource['name'] === trafficSourceName;
      });
      return Promise.resolve((_ref2 = trafficSource === null || trafficSource === void 0 ? void 0 : trafficSource.share) !== null && _ref2 !== void 0 ? _ref2 : '-');
    }, [trafficSourceName, trafficSources]);
    var handleTrafficSourceClick = (0, _react.useCallback)(function (trafficSourceName) {
      setTrafficSourceName(trafficSourceName);
      api.getTrafficSourceDetails(trafficSourceName).then(function (trafficSourceData) {
        setCurrentPage({
          data: trafficSourceData,
          view: 'traffic-source-detail'
        });
      });
    }, [api]);
    var handleTrafficSourceName = (0, _react.useCallback)(function (trafficSourceName) {
      setTrafficSourceName(trafficSourceName);
    }, []);
    var handleTrafficVolume = (0, _react.useCallback)(function () {
      var _ref3;

      var trafficSource = trafficSources.find(function (trafficSource) {
        return trafficSource['name'] === trafficSourceName;
      });
      return Promise.resolve((_ref3 = trafficSource === null || trafficSource === void 0 ? void 0 : trafficSource.value) !== null && _ref3 !== void 0 ? _ref3 : '-');
    }, [trafficSourceName, trafficSources]);

    var _useContext2 = (0, _react.useContext)(_store.StoreContext),
        _useContext3 = _slicedToArray(_useContext2, 1),
        readsEnabled = _useContext3[0].readsEnabled;

    var chartDataProviders = readsEnabled ? [getHistoricalViews, getHistoricalReads] : [getHistoricalViews];
    return _react["default"].createElement(_react["default"].Fragment, null, !validAnalyticsConnection && _react["default"].createElement(_alert["default"], {
      className: "p-0",
      displayType: "danger",
      variant: "stripe"
    }, Liferay.Language.get('an-unexpected-error-occurred')), validAnalyticsConnection && (hasWarning || hasHistoricalWarning) && _react["default"].createElement(_alert["default"], {
      className: "p-0",
      displayType: "warning",
      variant: "stripe"
    }, Liferay.Language.get('some-data-is-temporarily-unavailable')), currentPage.view === 'main' && _react["default"].createElement("div", {
      className: "p-3"
    }, _react["default"].createElement(_Main["default"], {
      authorName: authorName,
      chartDataProviders: chartDataProviders,
      defaultTimeRange: defaultTimeRange,
      defaultTimeSpanOption: defaultTimeSpanKey,
      languageTag: languageTag,
      onTrafficSourceClick: handleTrafficSourceClick,
      pagePublishDate: pagePublishDate,
      pageTitle: pageTitle,
      timeSpanOptions: timeSpanOptions,
      totalReadsDataProvider: handleTotalReads,
      totalViewsDataProvider: handleTotalViews,
      trafficSources: trafficSources
    })), currentPage.view === 'traffic-source-detail' && _react["default"].createElement(_Detail["default"], {
      currentPage: currentPage,
      languageTag: languageTag,
      onCurrentPageChange: handleCurrentPage,
      onTrafficSourceNameChange: handleTrafficSourceName,
      trafficShareDataProvider: handleTrafficShare,
      trafficVolumeDataProvider: handleTrafficVolume
    }));
  }

  Navigation.proptypes = {
    api: _propTypes["default"].object.isRequired,
    authorName: _propTypes["default"].string.isRequired,
    defaultTimeRange: _propTypes["default"].objectOf(_propTypes["default"].shape({
      endDate: _propTypes["default"].string.isRequired,
      startDate: _propTypes["default"].string.isRequired
    })).isRequired,
    defaultTimeSpanKey: _propTypes["default"].string.isRequired,
    languageTag: _propTypes["default"].string.isRequired,
    pagePublishDate: _propTypes["default"].number.isRequired,
    pageTitle: _propTypes["default"].string.isRequired,
    timeSpanOptions: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      key: _propTypes["default"].string.isRequired,
      label: _propTypes["default"].string.isRequired
    })).isRequired,
    trafficSources: _propTypes["default"].array.isRequired
  };
  //# sourceMappingURL=Navigation.js.map
});
//# sourceMappingURL=Navigation.js.map