Liferay.Loader.define("analytics-reports-web@1.0.26/js/components/detail/ReferralDetail", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../context/ChartStateContext', '../../utils/dateFormat', '../../utils/numberFormat', '../Hint', '../TimeSpanSelector', '../TotalCount'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = ReferralDetail;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _metalPosition = require("frontend-js-metal-web$metal-position");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ChartStateContext = require("../../context/ChartStateContext");

    var _dateFormat = require("../../utils/dateFormat");

    var _numberFormat = require("../../utils/numberFormat");

    var _Hint = _interopRequireDefault(require("../Hint"));

    var _TimeSpanSelector = _interopRequireDefault(require("../TimeSpanSelector"));

    var _TotalCount = _interopRequireDefault(require("../TotalCount"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var ITEMS_TO_SHOW = 5;

    function ReferralDetail(_ref) {
      var currentPage = _ref.currentPage,
          languageTag = _ref.languageTag,
          timeSpanOptions = _ref.timeSpanOptions,
          trafficShareDataProvider = _ref.trafficShareDataProvider,
          trafficVolumeDataProvider = _ref.trafficVolumeDataProvider;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          isReferringPagesExpanded = _useState2[0],
          setIsReferringPagesExpanded = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          isReferringDomainsExpanded = _useState4[0],
          setIsReferringDomainsExpanded = _useState4[1];

      var _currentPage$data = currentPage.data,
          referringDomains = _currentPage$data.referringDomains,
          referringPages = _currentPage$data.referringPages;
      var dateFormatters = (0, _react.useMemo)(function () {
        return (0, _dateFormat.generateDateFormatters)(languageTag);
      }, [languageTag]);

      var _useDateTitle = (0, _ChartStateContext.useDateTitle)(),
          firstDate = _useDateTitle.firstDate,
          lastDate = _useDateTitle.lastDate;

      var title = (0, _react.useMemo)(function () {
        return dateFormatters.formatChartTitle([firstDate, lastDate]);
      }, [dateFormatters, firstDate, lastDate]);
      var chartState = (0, _ChartStateContext.useChartState)();
      var isPreviousPeriodButtonDisabled = (0, _ChartStateContext.useIsPreviousPeriodButtonDisabled)();
      var changeTimeSpanKey = (0, _ChartStateContext.useChangeTimeSpanKey)();
      var nextTimeSpan = (0, _ChartStateContext.useNextTimeSpan)();
      var previousTimeSpan = (0, _ChartStateContext.usePreviousTimeSpan)();

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "c-p-3 traffic-source-detail"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-3 c-mt-2"
        }, /*#__PURE__*/_react.default.createElement(_TimeSpanSelector.default, {
          disabledNextTimeSpan: chartState.timeSpanOffset === 0,
          disabledPreviousPeriodButton: isPreviousPeriodButtonDisabled,
          onNextTimeSpanClick: nextTimeSpan,
          onPreviousTimeSpanClick: previousTimeSpan,
          onTimeSpanChange: function handleTimeSpanChange(event) {
            var value = event.target.value;
            changeTimeSpanKey({
              key: value
            });
          },
          timeSpanKey: chartState.timeSpanKey,
          timeSpanOptions: timeSpanOptions
        })), title && /*#__PURE__*/_react.default.createElement("h5", {
          className: "c-mb-4"
        }, title), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "c-mb-2",
          dataProvider: trafficVolumeDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('traffic-volume')),
          languageTag: languageTag,
          popoverAlign: _metalPosition.Align.Bottom,
          popoverHeader: Liferay.Language.get('traffic-volume'),
          popoverMessage: Liferay.Language.get('traffic-volume-is-the-number-of-page-views-coming-from-one-channel'),
          popoverPosition: "bottom"
        }), /*#__PURE__*/_react.default.createElement(_TotalCount.default, {
          className: "c-mb-3",
          dataProvider: trafficShareDataProvider,
          label: Liferay.Util.sub(Liferay.Language.get('traffic-share')),
          percentage: true,
          popoverHeader: Liferay.Language.get('traffic-share'),
          popoverMessage: Liferay.Language.get('traffic-share-is-the-percentage-of-traffic-sent-to-your-page-by-one-channel')
        }), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "list-group-pages-list"
        }, /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, {
          className: "text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, Liferay.Language.get('top-referring-pages'), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          message: Liferay.Language.get('top-referring-pages-help'),
          title: Liferay.Language.get('top-referring-pages')
        }))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, null, /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('traffic'))))), referringPages.slice(0, isReferringPagesExpanded ? 10 : ITEMS_TO_SHOW).map(function (_ref2) {
          var trafficAmount = _ref2.trafficAmount,
              url = _ref2.url;
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true,
              key: url
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
              className: "text-truncate-inline",
              "data-tooltip-align": "top",
              title: url
            }, /*#__PURE__*/_react.default.createElement("a", {
              className: "c-mr-2 text-primary text-truncate text-truncate-reverse",
              href: url,
              target: "_blank"
            }, url))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "align-self-end font-weight-semi-bold text-dark"
            }, (0, _numberFormat.numberFormat)(languageTag, trafficAmount))))
          );
        })), referringPages.length > 5 && /*#__PURE__*/_react.default.createElement(_button.default, {
          borderless: true,
          className: "c-mb-4",
          displayType: "secondary",
          onClick: function onClick() {
            return setIsReferringPagesExpanded(!isReferringPagesExpanded);
          },
          small: true
        }, isReferringPagesExpanded ? /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-less')) : /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-more'))), /*#__PURE__*/_react.default.createElement(_list.default, {
          className: "list-group-pages-list"
        }, /*#__PURE__*/_react.default.createElement(_list.default.Item, {
          flex: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, {
          className: "text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate"
        }, Liferay.Language.get('top-referring-domains'), /*#__PURE__*/_react.default.createElement("span", {
          className: "text-secondary"
        }, /*#__PURE__*/_react.default.createElement(_Hint.default, {
          message: Liferay.Language.get('top-referring-domains-help'),
          title: Liferay.Language.get('top-referring-domains')
        }))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, null, /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('traffic'))))), referringDomains.slice(0, isReferringDomainsExpanded ? 10 : ITEMS_TO_SHOW).map(function (_ref3) {
          var trafficAmount = _ref3.trafficAmount,
              url = _ref3.url;
          return (/*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true,
              key: url
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
              className: "text-truncate-inline",
              "data-tooltip-align": "top",
              title: url
            }, /*#__PURE__*/_react.default.createElement("a", {
              className: "c-mr-2 text-primary text-truncate",
              href: url,
              target: "_blank"
            }, url))))), /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "align-self-end font-weight-semi-bold text-dark"
            }, (0, _numberFormat.numberFormat)(languageTag, trafficAmount))))
          );
        })), referringDomains.length > 5 && /*#__PURE__*/_react.default.createElement(_button.default, {
          borderless: true,
          className: "c-mb-4",
          displayType: "secondary",
          onClick: function onClick() {
            return setIsReferringDomainsExpanded(!isReferringDomainsExpanded);
          },
          small: true
        }, isReferringDomainsExpanded ? /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-less')) : /*#__PURE__*/_react.default.createElement("span", null, Liferay.Language.get('view-more'))))
      );
    }
    //# sourceMappingURL=ReferralDetail.js.map
  }
});
//# sourceMappingURL=ReferralDetail.js.map