"use strict";

Liferay.Loader.define("analytics-reports-web$dom-helpers@3.4.0/transition/properties", ['module', 'exports', 'require', '@analytics-reports-web$babel/runtime/helpers/interopRequireDefault', '../util/inDOM'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var _interopRequireDefault = require("@analytics-reports-web$babel/runtime/helpers/interopRequireDefault");

    exports.__esModule = true;
    exports.default = exports.animationEnd = exports.animationDelay = exports.animationTiming = exports.animationDuration = exports.animationName = exports.transitionEnd = exports.transitionDuration = exports.transitionDelay = exports.transitionTiming = exports.transitionProperty = exports.transform = void 0;

    var _inDOM = _interopRequireDefault(require("../util/inDOM"));

    var transform = 'transform';
    exports.transform = transform;
    var prefix, transitionEnd, animationEnd;
    exports.animationEnd = animationEnd;
    exports.transitionEnd = transitionEnd;
    var transitionProperty, transitionDuration, transitionTiming, transitionDelay;
    exports.transitionDelay = transitionDelay;
    exports.transitionTiming = transitionTiming;
    exports.transitionDuration = transitionDuration;
    exports.transitionProperty = transitionProperty;
    var animationName, animationDuration, animationTiming, animationDelay;
    exports.animationDelay = animationDelay;
    exports.animationTiming = animationTiming;
    exports.animationDuration = animationDuration;
    exports.animationName = animationName;

    if (_inDOM.default) {
      var _getTransitionPropert = getTransitionProperties();

      prefix = _getTransitionPropert.prefix;
      exports.transitionEnd = transitionEnd = _getTransitionPropert.transitionEnd;
      exports.animationEnd = animationEnd = _getTransitionPropert.animationEnd;
      exports.transform = transform = prefix + "-" + transform;
      exports.transitionProperty = transitionProperty = prefix + "-transition-property";
      exports.transitionDuration = transitionDuration = prefix + "-transition-duration";
      exports.transitionDelay = transitionDelay = prefix + "-transition-delay";
      exports.transitionTiming = transitionTiming = prefix + "-transition-timing-function";
      exports.animationName = animationName = prefix + "-animation-name";
      exports.animationDuration = animationDuration = prefix + "-animation-duration";
      exports.animationTiming = animationTiming = prefix + "-animation-delay";
      exports.animationDelay = animationDelay = prefix + "-animation-timing-function";
    }

    var _default = {
      transform: transform,
      end: transitionEnd,
      property: transitionProperty,
      timing: transitionTiming,
      delay: transitionDelay,
      duration: transitionDuration
    };
    exports.default = _default;

    function getTransitionProperties() {
      var style = document.createElement('div').style;
      var vendorMap = {
        O: function O(e) {
          return "o" + e.toLowerCase();
        },
        Moz: function Moz(e) {
          return e.toLowerCase();
        },
        Webkit: function Webkit(e) {
          return "webkit" + e;
        },
        ms: function ms(e) {
          return "MS" + e;
        }
      };
      var vendors = Object.keys(vendorMap);
      var transitionEnd, animationEnd;
      var prefix = '';

      for (var i = 0; i < vendors.length; i++) {
        var vendor = vendors[i];

        if (vendor + "TransitionProperty" in style) {
          prefix = "-" + vendor.toLowerCase();
          transitionEnd = vendorMap[vendor]('TransitionEnd');
          animationEnd = vendorMap[vendor]('AnimationEnd');
          break;
        }
      }

      if (!transitionEnd && 'transitionProperty' in style) transitionEnd = 'transitionend';
      if (!animationEnd && 'animationName' in style) animationEnd = 'animationend';
      style = null;
      return {
        animationEnd: animationEnd,
        transitionEnd: transitionEnd,
        prefix: prefix
      };
    }
  }
});
//# sourceMappingURL=properties.js.map