Liferay.Loader.define("analytics-reports-web@1.0.21/js/components/TimeSpanSelector", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../context/ConnectionContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = TimeSpanSelector;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ConnectionContext = _interopRequireDefault(require("../context/ConnectionContext"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function TimeSpanSelector(_ref) {
      var disabledNextTimeSpan = _ref.disabledNextTimeSpan,
          disabledPreviousPeriodButton = _ref.disabledPreviousPeriodButton,
          onNextTimeSpanClick = _ref.onNextTimeSpanClick,
          onPreviousTimeSpanClick = _ref.onPreviousTimeSpanClick,
          onTimeSpanChange = _ref.onTimeSpanChange,
          timeSpanKey = _ref.timeSpanKey,
          timeSpanOptions = _ref.timeSpanOptions;

      var _useContext = (0, _react.useContext)(_ConnectionContext.default),
          validAnalyticsConnection = _useContext.validAnalyticsConnection;

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "d-flex mb-3 mt-4"
        }, /*#__PURE__*/_react.default.createElement(_form.ClaySelect, {
          "aria-label": Liferay.Language.get('select-date-range'),
          className: "bg-white",
          disabled: !validAnalyticsConnection,
          onChange: onTimeSpanChange,
          value: timeSpanKey
        }, timeSpanOptions.map(function (option) {
          return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect.Option, {
              key: option.key,
              label: option.label,
              value: option.key
            })
          );
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "d-flex ml-2"
        }, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
          "aria-label": Liferay.Language.get('previous-period'),
          className: "mr-1",
          "data-tooltip-align": "top-right",
          disabled: !validAnalyticsConnection || disabledPreviousPeriodButton,
          displayType: "secondary",
          onClick: onPreviousTimeSpanClick,
          small: true,
          symbol: "angle-left",
          title: disabledPreviousPeriodButton ? Liferay.Language.get('you-cannot-choose-a-date-prior-to-the-publication-date') : undefined
        })), /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
          "aria-label": Liferay.Language.get('next-period'),
          disabled: !validAnalyticsConnection || disabledNextTimeSpan,
          displayType: "secondary",
          onClick: onNextTimeSpanClick,
          small: true,
          symbol: "angle-right"
        })))
      );
    }

    TimeSpanSelector.proptypes = {
      disabledNextTimeSpan: _propTypes.default.bool.isRequired,
      disabledPreviousPeriodButton: _propTypes.default.bool.isRequired,
      onNextTimeSpanClick: _propTypes.default.func.isRequired,
      onPreviousTimeSpanClick: _propTypes.default.func.isRequired,
      onTimeSpanChange: _propTypes.default.func.isRequired,
      timeSpanKey: _propTypes.default.string.isRequired,
      timeSpanOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
        key: _propTypes.default.string.isRequired,
        label: _propTypes.default.string.isRequired
      })).isRequired
    };
    //# sourceMappingURL=TimeSpanSelector.js.map
  }
});
//# sourceMappingURL=TimeSpanSelector.js.map